/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/

#include <Inventor/ViewerComponents/Win/WinTimer.h>

#define _MSECOND 10000LL

//------------------------------------------------------------------------------
VOID CALLBACK
TimerAPCProc( LPVOID lpArg, DWORD dwTimerLowValue, DWORD dwTimerHighValue )
{
  UNREFERENCED_PARAMETER(dwTimerLowValue);
  UNREFERENCED_PARAMETER(dwTimerHighValue);

  WinTimer *timer = (WinTimer *)lpArg;
  timer->timeOut();
}

//------------------------------------------------------------------------------
WinTimer::WinTimer()
  : m_task(NULL), m_delay(0), m_singleShot(false),m_started(false)
{
  m_timer = CreateWaitableTimer( NULL, FALSE, TEXT("WinTimer"));
}

//------------------------------------------------------------------------------
void
WinTimer::stop()
{
  CancelWaitableTimer( m_timer );
  m_started = false;
}

//------------------------------------------------------------------------------
void
WinTimer::start()
{
  if ( m_started )
    CancelWaitableTimer( m_timer );

  m_started = true;
  LARGE_INTEGER delay;

  // Check if delay != 0 because delay equal to 0 freeze the application
  if ( m_delay != 0 )
    delay.QuadPart = - _MSECOND * (uint32_t)m_delay;
  else
    delay.QuadPart = -1;

  int loopDelay = m_delay;
  if ( m_singleShot )
    loopDelay = 0;


  bool result = SetWaitableTimer( m_timer, &delay, loopDelay, TimerAPCProc, this, FALSE );
  if( ! result )
    return;
}

//------------------------------------------------------------------------------
void
WinTimer::setDelay(int time)
{
  m_delay = time;
}

//------------------------------------------------------------------------------
bool
WinTimer::isPending() const
{
  return m_started;
}

//------------------------------------------------------------------------------
void
WinTimer::setRepeat(bool flag)
{
  m_singleShot = !flag;
}

//------------------------------------------------------------------------------
void
WinTimer::setTask(SoSystemTimerTask* task)
{
  m_task = task;
}

//------------------------------------------------------------------------------
void
WinTimer::timeOut()
{
  m_started = false;

  if ( m_task.ptr() != NULL )
    m_task->run();
}
