#pragma once

#include "OrbitAnimator.h"
#include "SeekAnimator.h"
#include <Inventor/touch/events/SoTouchEvent.h>
#include <Inventor/ViewerComponents/nodes/SceneOrbiter.h>

class SoKeyboardEvent;
class SoCameraInteractor;
class SoMouseButtonEvent;
class SoMouseWheelEvent;
class SoLocation2Event;
class SoHandleEventAction;
class SoEvent;
class SoScaleGestureEvent;
class SoRotateGestureEvent;

class InteractionOrbiter
{
public:
  InteractionOrbiter( SoCameraInteractor* cameraInteractor );
  InteractionOrbiter( const InteractionOrbiter& copyFrom );
  virtual ~InteractionOrbiter();

  void beginAction( SoMouseButtonEvent* mouseEvent, SoHandleEventAction* action );
  void beginAction( SoKeyboardEvent* keyEvent, SoHandleEventAction* action );
  void beginAction( SoHandleEventAction* action, bool ctrlDown, bool shiftDown );
  void doAction( SoMouseWheelEvent* wheelEvent, SoHandleEventAction* action );
  void doAction( SoLocation2Event* mouseEvent, SoHandleEventAction* action );
  void doAction( SoTouchEvent* touchEvent, SoHandleEventAction* action );
  void doAction( SoScaleGestureEvent* scaleEvent, SoHandleEventAction* action );
  void doAction( SoRotateGestureEvent* rotateEvent, SoHandleEventAction* action);

  void reset();
  void setCameraInteractor( SoCameraInteractor* cameraInteractor );
  void setConstraintLevel( float level );
  float getConstraintLevel();
  void setRotationMethod( SceneOrbiter::RotationMethod method );
  SceneOrbiter::RotationMethod getRotationMethod();
  void setUpAxis( openinventor::inventor::Axis::Type axis );
  openinventor::inventor::Axis::Type getUpAxis();

protected:
  void beginSelection( SoHandleEventAction* action );
  void beginPan( SoHandleEventAction* action );
  void beginOrbit( SoHandleEventAction* action );
  void doIdentifyGesture( SoEvent* anyEvent, SoHandleEventAction* action );
  void doPan( const SoEvent* anyEvent, SoHandleEventAction* action );
  void doOrbit( SoEvent* anyEvent, SoHandleEventAction* action );
  void doTurntableOrbit( SoEvent* anyEvent, SoHandleEventAction* action );
  void doDolly( SoEvent* anyEvent, SoHandleEventAction* action );
  void doDollyWithCenter( const SbVec2f& center, float scaleFactor, SoHandleEventAction* action );
  void doTranslate(const SoTouchEvent* touchEvent, SoHandleEventAction* action);

  void interactiveCountInc();
  void interactiveCountDec();

  SoCameraInteractor* m_cameraInteractor;
  SceneOrbiter::RotationMethod m_orbitMethod;
  openinventor::inventor::Axis::Type m_upAxis;
  float m_turntableConstraintLevel;

  bool m_selectionAllowed;
  bool m_isButton1Down;
  SbVec2f m_mousePositionNorm;
  SbVec2s m_mousePosition;
  int m_mouseWheelDelta;
  unsigned long m_eventTime;

  int m_waitBeforeMoving;
  bool m_canMove;

private:
  void startInteraction();

  int m_interactiveCount;
  SoHandleEventAction* m_currentAction;
  SoAlarmSensor* m_interactionEndSensor;

  static const float s_selectionEpsilon;
  static const int s_nbMovesBeforeStartMoving;
  // waiting time for a new interaction
  static const double s_interaction_time;
  // Speed value to define what we consider as a fast movement.
  // Default is 3 pixels / ms.
  static const double s_maxInteractionSpeed;

};
