/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Jean-Paul Digeon (Sep 2011)
**=======================================================================*/
#ifndef IVT_TOOLS_PLUGIN_H
#define IVT_TOOLS_PLUGIN_H

//////////////////////////////////////////////////////////////////////////////
//
//  Class: IvtToolsPlugin
//
//////////////////////////////////////////////////////////////////////////////

#include <IvTune/IvTuneExtender/IvtPlugin.h>

#include <Ivt_DirectionalLightEditor.h>
#include <Ivt_ProcessingMenu.h>
#include <Ivt_ShaderEditor.h>
#include <Ivt_ViewingToolbar.h>


extern "C" IVTUNEPLG_API IvtPlugin* loadPlugin();
extern "C" IVTUNEPLG_API void unloadPlugin();

class IvtToolsPlugin : public IvtPlugin
{

public:

  /**
   * Constructor.
   */
  IvtToolsPlugin();

  /**
   * Destructor.
   */
  virtual ~IvtToolsPlugin();

  /**
   * Loads the extensions of this plug-in.
   */
  virtual void load();

private:

  // Extensions

  Ivt_DirectionalLightEditor m_dirLightEditor;
  Ivt_ProcessingMenu m_processingMenu;
  Ivt_ShaderEditor m_shaderEditor;
  Ivt_ViewingToolbar m_viewingToolbar;
};

#endif // IVT_TOOLS_PLUGIN_H


