/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Fabien ARNAUD (MMM yyyy)
** Modified by : T.MEHAMLI (Dec 2010)
**=======================================================================*/
#include <Ivt_PMSplitDialog.h>

#include <QBoxLayout>
#include <QCheckBox>
#include <QGroupBox>
#include <QHBoxLayout>
#include <QLabel>
#include <QLayout>
#include <QPushButton>
#include <QtCore/QSize>
#include <QSlider>
#include <QSpinBox>
#include <QVBoxLayout>

#include <Inventor/nodes/SoSeparator.h>
#include <Inventor/actions/SoSplitGeometryAction.h>


////////////////////////////////////////////////////////////////////////
// Constructor
Ivt_PMSplitDialog::Ivt_PMSplitDialog( QWidget* parent, SoGroup* root )
: QDialog( parent, Qt::MSWindowsFixedSizeDialogHint | Qt::WindowTitleHint | Qt::WindowSystemMenuHint | Qt::WindowCloseButtonHint )
{
  // Tune the dialog
  setModal( false );
  m_root = root;
  setWindowTitle( tr("Split Shapes") );

  // Build widgets
  m_smartSplittingButton = new QCheckBox( tr("Do Smart Splitting"), this );
  m_smartSplittingButton->setChecked( true );
  m_seeSplitPartsButton = new QCheckBox( tr("See Split Parts"), this );
  m_seeSplitPartsButton->setChecked( true );
  m_traverseAllSwitchChildrenButton = new QCheckBox( tr("Traverse All SoSwitch Children"), this );
  m_traverseAllSwitchChildrenButton->setChecked( false );

  QGroupBox* dimGroup = new QGroupBox( "Number Of Divisions", this );
  QWidget* XHBox = new QWidget( dimGroup );
  QHBoxLayout* hlx = new QHBoxLayout( XHBox );
  m_divXSpinBox = new QSpinBox( XHBox );
  m_divXSpinBox->setMinimum( 1 );
  m_divXSpinBox->setMaximum( 20 );
  m_divXSpinBox->setValue( 4 );
  QLabel* qlx = new QLabel( "   X", XHBox );
  hlx->addWidget( m_divXSpinBox );
  hlx->addWidget( qlx );
  QWidget* YHBox = new QWidget( dimGroup );
  QHBoxLayout* hly = new QHBoxLayout( YHBox );
  m_divYSpinBox = new QSpinBox ( YHBox );
  m_divYSpinBox->setMinimum( 1 );
  m_divYSpinBox->setMaximum( 20 );
  m_divYSpinBox->setValue( 4 );
  QLabel* qly = new QLabel( "   Y", YHBox );
  hly->addWidget( m_divYSpinBox );
  hly->addWidget( qly );
  QWidget* ZHBox = new QWidget( dimGroup );
  QHBoxLayout* hlz = new QHBoxLayout( ZHBox );
  m_divZSpinBox = new QSpinBox( ZHBox );
  m_divZSpinBox->setMinimum( 1 );
  m_divZSpinBox->setMaximum( 20 );
  m_divZSpinBox->setValue( 4 );
  QLabel* qlz = new QLabel( "   Z", ZHBox );
  hlz->addWidget( m_divZSpinBox );
  hlz->addWidget( qlz );

  QBoxLayout* dimGroupLayout = new QVBoxLayout( dimGroup );
  dimGroupLayout->setContentsMargins( 10, 10, 10, 10 );
  dimGroupLayout->setSpacing( 5 );
  dimGroupLayout->addSpacing (10);
  dimGroupLayout->addWidget( XHBox );
  dimGroupLayout->addWidget( YHBox );
  dimGroupLayout->addWidget( ZHBox );

  QWidget* ApplyButtonHBox = new QWidget( this );
  QHBoxLayout* hlab = new QHBoxLayout( ApplyButtonHBox );
  hlab->addWidget( new QLabel("         ", ApplyButtonHBox), 0 );
  QPushButton* applyButton = new QPushButton( "Apply", ApplyButtonHBox );
  connect( applyButton, SIGNAL(clicked()), this, SLOT(onApply()) );

  QBoxLayout* main_layout = new QVBoxLayout( this );
  main_layout->setContentsMargins( 10, 10, 10, 10 );
  main_layout->addWidget( m_smartSplittingButton );
  main_layout->addSpacing( 5 );
  main_layout->addWidget( m_seeSplitPartsButton );
  main_layout->addSpacing( 5 );
  main_layout->addWidget( m_traverseAllSwitchChildrenButton );
  main_layout->addSpacing( 10 );
  main_layout->addWidget( dimGroup );
  main_layout->addSpacing( 10 );
  main_layout->addWidget( ApplyButtonHBox );
}

////////////////////////////////////////////////////////////////////////
void Ivt_PMSplitDialog::onApply ()
{
  SoSplitGeometryAction action( m_divXSpinBox->value(), m_divYSpinBox->value(), m_divZSpinBox->value() );
  action.setSmartSplitting( m_smartSplittingButton->isChecked() );
  action.setTraverseAllSoSwitchChildren( m_traverseAllSwitchChildrenButton->isChecked() );
  action.setDistinguishSplitParts( m_seeSplitPartsButton->isChecked() );
  action.apply( m_root );
  
  done( 0 );
}


