/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2017 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : T.MEHAMLI (Dec 2010)
**=======================================================================*/
#ifndef IVT_PROCESSING_MENU_ACTIONS_MANAGER_H
#define IVT_PROCESSING_MENU_ACTIONS_MANAGER_H

//////////////////////////////////////////////////////////////////////////////
//
//  Class: Ivt_ProcessingMenuActionsManager
//
//////////////////////////////////////////////////////////////////////////////

/** 
 * @VSGEXT IvTune class which performs actions for the processing menu.
 *
 * @ingroup IvtTools
 *
 * @DESCRIPTION
 *
 * This class performs the actions of the processing menu.
 *
 */

class SoNode;
class SoOctreeOrdering;
class SoValueOrdering;

class Ivt_ProcessingMenuActionsManager
{
public:
  /**
   * Constructor.
   */
  Ivt_ProcessingMenuActionsManager();

  /**
   * Destructor.
   */
  ~Ivt_ProcessingMenuActionsManager();

  // Processing menu actions
  /**
   * Reorganizes the scene using triangle strips and returns true if succeeded.
   */
  bool reorganizeProcess( SoNode* node );

  /**
   * Simplifies the shapes in the scene.
   * If doTS is true, it will use triangle strips.
   */
  void shapeSimplifyProcess( SoNode* node, bool doTS = false );

  /**
   * Simplifies the whole scene and returns true if succeded.
   * If doTS is true, it will use triangle strips.
   */
  bool globalSimplifyProcess( SoNode* node, bool doTS = false );

  /**
   * Opens a dialog to tune the split action applied to the shapes of the scene.
   */
  virtual void splitShapesProcess( SoNode* node );

private:
  /** 
   * Reorganizes each child of the LevelOfSimplification nodes under "graph".  
   * This will cause each representation to be in triangle strips instead of face sets.
   */
  void reorganizeSimplified( SoNode* graph );

};

#endif // IVT_PROCESSING_MENU_ACTIONS_MANAGER_H

