/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2024 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : Tristan MEHAMLI (Dec 2010)
**=======================================================================*/

#include <Ivt_ShaderSyntaxHighlight.h>
#include <Ivt_ShaderSyntaxKeywords.h>

#include <QtCore/QStringList>

#include <QTextDocument>

//------------------------------------------------------------------------------
Ivt_ShaderSyntaxHighlight::Ivt_ShaderSyntaxHighlight( QTextDocument* parent )
: QSyntaxHighlighter(parent)
{
  // Set regular expressions
  m_commentStartExpression = QRegularExpression("/\\*");
  m_commentEndExpression = QRegularExpression( "\\*/" );
  m_groupExpression = QRegularExpression( "^\\[[^\\]]*\\]" );

  // Init
  init();
}

//------------------------------------------------------------------------------
Ivt_ShaderSyntaxHighlight::~Ivt_ShaderSyntaxHighlight()
{
}

//------------------------------------------------------------------------------
void 
Ivt_ShaderSyntaxHighlight::highlightBlock( const QString& text )
{
  if ( !text.isEmpty() )
  {
    foreach( HighlightingRule rule, m_highlightingRules ) 
    {
      QRegularExpression expression( rule.pattern );
      QRegularExpressionMatch match = expression.match( text );
      int index = match.capturedStart();
      while ( index >= 0 ) 
      {
        int length = match.capturedLength();
        setFormat( index, length, rule.format );
        match = expression.match( text, index + length );
        index = match.capturedStart();
      }
    }
    setCurrentBlockState( 0 );

    int startIndex = 0;
    if ( previousBlockState() != 1 )
    {
      QRegularExpressionMatch matchStart = m_commentStartExpression.match( text );
      startIndex = matchStart.capturedStart();
    }

    while ( startIndex >= 0 ) 
    {
      QRegularExpressionMatch matchEnd = m_commentEndExpression.match( text, startIndex );
      int endIndex = matchEnd.capturedStart();
      int commentLength;
      if ( endIndex == -1 ) 
      {
        setCurrentBlockState( 1 );
        commentLength = text.length() - startIndex;
      }
      else 
        commentLength = endIndex - startIndex + matchEnd.capturedLength();
      setFormat( startIndex, commentLength, m_multiLineCommentFormat );
      QRegularExpressionMatch matchStart = m_commentStartExpression.match( text, startIndex + commentLength );
      startIndex = matchStart.capturedStart();
    }
  }
}

//------------------------------------------------------------------------------
void 
Ivt_ShaderSyntaxHighlight::init()
{
  // Set the different color and font weight for each text format
  m_singleLineCommentFormat.setForeground( g_comment );
  m_multiLineCommentFormat.setForeground( g_comment );
  m_shdBoolean.setForeground( g_boolean );
  m_shdBoolean.setFontWeight( QFont::Bold );
  m_shdBuiltins.setForeground( g_builtins );
  m_shdBuiltins.setFontWeight( QFont::Bold );
  m_shdConditional.setForeground( g_conditional );
  m_shdConditional.setFontWeight( QFont::Bold );
  m_shdConstants.setForeground( g_constants );
  m_shdConstants.setFontWeight( QFont::Bold );
  m_shdFunctions.setForeground( g_functions );
  m_shdFunctions.setFontWeight( QFont::Bold );
  m_shdGroup.setForeground( g_groups );
  m_shdMembers.setForeground( g_members );
  m_shdMembers.setFontWeight( QFont::Bold );
  m_shdRepeat.setForeground(g_repeat );
  m_shdRepeat.setFontWeight( QFont::Bold );
  m_shdSemantic.setForeground( g_semantic );
  m_shdSemantic.setFontWeight( QFont::Bold );
  m_shdState.setForeground( g_state );
  m_shdState.setFontWeight( QFont::Bold );
  m_shdStatement.setForeground( g_statement );
  m_shdStatement.setFontWeight( QFont::Bold );
  m_shdStorageClass.setForeground( g_storageClass );
  m_shdStorageClass.setFontWeight( QFont::Bold );
  m_shdStructure.setForeground( g_structure );
  m_shdStructure.setFontWeight( QFont::Bold );
  m_shdSwizzleCoordinate.setForeground( g_swizzles );
  m_shdSwizzleRGBA.setForeground(g_swizzles );
  m_shdSwizzleTexCoord.setForeground( g_swizzles );
  m_shdTodo.setForeground( g_todo );
  m_shdTodo.setFontWeight( QFont::Bold );
  m_shdType.setForeground( g_type );
  m_shdType.setFontWeight( QFont::Bold );

  // Define rules for each group
  QStringList group;
  HighlightingRule rule;
  int i;

  //----------------------------//
  // Shaders specific higlights //
  //----------------------------//
  // m_shdBoolean
  i = 0;
  while( g_shdBoolean[i] )
  {
    group << g_shdBoolean[i];
    i++;
  }
  foreach( QString pattern, group ) 
  {
    QString regExp = QString( "\\b" ) + pattern + QString( "\\b" );
    rule.pattern = QRegularExpression( regExp );
    rule.format = m_shdBoolean;
    m_highlightingRules.append( rule );
  }
  group.clear();

  // m_shdBuiltins
  i = 0;
  while( g_shdBuiltins[i] )
  {
    group << g_shdBuiltins[i];
    i++;
  }
  foreach( QString pattern, group ) 
  {
    QString regExp = QString( "\\b" ) + pattern + QString( "\\b" );
    rule.pattern = QRegularExpression( regExp );
    rule.format = m_shdBuiltins;
    m_highlightingRules.append( rule );
  }
  group.clear();

  // m_shdConditional
  i = 0;
  while( g_shdConditional[i] )
  {
    group << g_shdConditional[i];
    i++;
  }
  foreach( QString pattern, group ) 
  {
    QString regExp = QString( "\\b" ) + pattern + QString( "\\b" );
    rule.pattern = QRegularExpression( regExp );
    rule.format = m_shdConditional;
    m_highlightingRules.append( rule );
  }
  group.clear();

  // m_shdConstants
  i = 0;
  while( g_shdConstants[i] )
  {
    group << g_shdConstants[i];
    i++;
  }
  foreach( QString pattern, group ) 
  {
    QString regExp = QString( "\\b" ) + pattern + QString( "\\b" );
    rule.pattern = QRegularExpression( regExp );
    rule.format = m_shdConstants;
    m_highlightingRules.append( rule );
  }
  group.clear();

  // m_shdFunctions
  i = 0;
  while( g_shdFunctions[i] )
  {
    group << g_shdFunctions[i];
    i++;
  }
  foreach( QString pattern, group ) 
  {
    QString regExp = QString( "\\b" ) + pattern + QString( "\\b" );
    rule.pattern = QRegularExpression( regExp );
    rule.format = m_shdFunctions;
    m_highlightingRules.append( rule );
  }
  group.clear();

  // m_shdGroup
  rule.pattern = m_groupExpression;
  rule.format = m_shdGroup;
  m_highlightingRules.append( rule );

  // m_shdMembers
  i = 0;
  while( g_shdMembers[i] )
  {
    group << g_shdMembers[i];
    i++;
  }
  foreach( QString pattern, group ) 
  {
    QString regExp = QString( "\\b" ) + pattern + QString( "\\b" );
    rule.pattern = QRegularExpression( regExp );
    rule.format = m_shdMembers;
    m_highlightingRules.append( rule );
  }
  group.clear();

  // m_shdRepeat
  i = 0;
  while( g_shdRepeat[i] )
  {
    group << g_shdRepeat[i];
    i++;
  }
  foreach( QString pattern, group ) 
  {
    QString regExp = QString( "\\b" ) + pattern + QString( "\\b" );
    rule.pattern = QRegularExpression( regExp );
    rule.format = m_shdRepeat;
    m_highlightingRules.append( rule );
  }
  group.clear();

  // m_shdSemantic
  i = 0;
  while( g_shdSemantic[i] )
  {
    group << g_shdSemantic[i];
    i++;
  }
  foreach( QString pattern, group ) 
  {
    QString regExp = QString( "\\b" ) + pattern + QString( "\\b" );
    rule.pattern = QRegularExpression( regExp );
    rule.format = m_shdSemantic;
    m_highlightingRules.append( rule );
  }
  group.clear();

  // m_shdState
  i = 0;
  while( g_shdState[i] )
  {
    group << g_shdState[i];
    i++;
  }
  foreach( QString pattern, group ) 
  {
    QString regExp = QString( "\\b" ) + pattern + QString( "\\b" );
    rule.pattern = QRegularExpression( regExp );
    rule.format = m_shdState;
    m_highlightingRules.append( rule );
  }
  group.clear();

  // m_shdStatement
  i = 0;
  while( g_shdStatement[i] )
  {
    group << g_shdStatement[i];
    i++;
  }
  foreach( QString pattern, group ) 
  {
    QString regExp = QString( "\\b" ) + pattern + QString( "\\b" );
    rule.pattern = QRegularExpression( regExp );
    rule.format = m_shdStatement;
    m_highlightingRules.append( rule );
  }
  group.clear();

  // m_shdStorageClass
  i = 0;
  while( g_shdStorageClass[i] )
  {
    group << g_shdStorageClass[i];
    i++;
  }
  foreach( QString pattern, group ) 
  {
    QString regExp = QString( "\\b" ) + pattern + QString( "\\b" );
    rule.pattern = QRegularExpression( regExp );
    rule.format = m_shdStorageClass;
    m_highlightingRules.append( rule );
  }
  group.clear();

  // m_shdStructure
  i = 0;
  while( g_shdStructure[i] )
  {
    group << g_shdStructure[i];
    i++;
  }
  foreach( QString pattern, group ) 
  {
    QString regExp = QString( "\\b" ) + pattern + QString( "\\b" );
    rule.pattern = QRegularExpression( regExp );
    rule.format = m_shdStructure;
    m_highlightingRules.append( rule );
  }
  group.clear();

  // m_shdSwizzleCoordinate
  rule.pattern = QRegularExpression( "\\.[wxyz]{1,4}\\b" );
  rule.format = m_shdSwizzleCoordinate;
  m_highlightingRules.append( rule );

  // m_shdSwizzleRGBA
  rule.pattern = QRegularExpression( "\\.[rgba]{1,4}\\b" );
  rule.format = m_shdSwizzleRGBA;
  m_highlightingRules.append( rule );

  // m_shdSwizzleTexCoord
  rule.pattern = QRegularExpression( "\\.[stpq]{1,4}\\b" );
  rule.format = m_shdSwizzleTexCoord;
  m_highlightingRules.append( rule );

  // m_shdTodo
  i = 0;
  while( g_shdTodo[i] )
  {
    group << g_shdTodo[i];
    i++;
  }
  foreach( QString pattern, group ) 
  {
    QString regExp = QString( "\\b" ) + pattern + QString( "\\b" );
    rule.pattern = QRegularExpression( regExp );
    rule.format = m_shdTodo;
    m_highlightingRules.append( rule );
  }
  group.clear();

  // m_shdType
  i = 0;
  while( g_shdType[i] )
  {
    group << g_shdType[i];
    i++;
  }
  foreach( QString pattern, group ) 
  {
    QString regExp = QString( "\\b" ) + pattern + QString( "\\b" );
    rule.pattern = QRegularExpression( regExp );
    rule.format = m_shdType;
    m_highlightingRules.append( rule );
  }
  group.clear();

  //------------------------//
  // Special text higlights //
  //------------------------//
  rule.pattern = QRegularExpression( "//[^\n]*" );
  rule.format = m_singleLineCommentFormat;
  m_highlightingRules.append( rule );
}


