# some policies defining cmake behavior
# see cmake --help-policy CMPXXXX

if(COMMAND cmake_policy)
 cmake_policy(SET CMP0000 NEW) # require cmake_minimum_required call
 cmake_policy(SET CMP0002 NEW) # target names are required to be globaly unique
 cmake_policy(SET CMP0003 NEW) # do not add linker search path when libs are specified with full path
 cmake_policy(SET CMP0011 NEW) # automatic cmake_policy PUSH and POP of environment for include() and find_package()
 cmake_policy(SET CMP0023 NEW) # do not allow mixed target_link_libraries signatures
 cmake_policy(SET CMP0048 NEW) # allow managing version number in project definition
 cmake_policy(SET CMP0054 NEW) # do not interpret if() arguments as variables or keywords when quoted.
 if(NOT (${CMAKE_VERSION} VERSION_LESS "3.10.0"))
   cmake_policy(SET CMP0071 NEW) # Do not ignore GENERATED files
 endif()
 if(NOT (${CMAKE_VERSION} VERSION_LESS "3.19.0"))
   cmake_policy(SET CMP0110 NEW) # Support arbitrary characters in test names
 endif()
 if(NOT (${CMAKE_VERSION} VERSION_LESS "3.29.0"))
   cmake_policy(SET CMP0146 OLD) # Enable FindCUDA module
 endif()
endif()

set_property(GLOBAL PROPERTY USE_FOLDERS ON)
