include (GPUDetection.cmake)
include (SystemDetection.cmake)

####################################################################
# WARNING : DO NOT USE ANY VARIABLE NAME IN COMMENT OF THIS FILE   #
# CONFIGURE_FILE REPLACE THEM WITH THEIR CMAKE VALUE EVENT IF THEY #
# ARE COMMENTED. JUST USE THEM IN TEST BUT NOT IN COMMENT          #
####################################################################

# see https://cmake.org/pipermail/cdash/2011-April/000970.html
# and http://www.vtk.org/Wiki/CMake_Testing_With_CTest#Customizing_CTest
# Some clang lines are interpreted as error by CTest.
# See https://github.com/Kitware/CMake/blob/master/Source/CTest/cmCTestBuildHandler.cxx
# to see what CTest use as regexp to match warning, errors, etc...
# Here, we add a rule to exclude line matching these regexp from errors
#
# Also see http://www.regexr.com/. Very usefull site to test regexp

if(APPLE)
  SET(CTEST_CUSTOM_ERROR_EXCEPTION
    ${CTEST_CUSTOM_ERROR_EXCEPTION}
      "([^ :]+):([0-9]+): ([^ \\t])"
  )
endif()

# AMD specific issues. #52805
if( GPU_NAME MATCHES "AMD" )
  SET(CTEST_CUSTOM_TESTS_IGNORE
  ${CTEST_CUSTOM_TESTS_IGNORE}

  ############################################################################
  # Demos
  ############################################################################
  RUN_CustomNodePyramid #API-19
  [default]_Inventor/Features/ClipPlaneManip/art1480.art

  ############################################################################
  # UnitTests
  ############################################################################
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRPropertyMask/propertyMaskOnOff.art #54267
  [default]_Inventor/AlphaPolicy/alphapolicy_zbuff_sorted_pixel.art #65312
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRTransparency/transparency2.art
  [default]_VolumeViz/raycastTransparency/artFiles/DELAYED_SORTED_LAYERS_BLEND/art4755_DELAYED_SORTED_LAYERS_BLEND.art
  [default]_VolumeViz/raycastTransparency/artFiles/DELAYED_SORTED_LAYERS_BLEND/artD679_DELAYED_SORTED_LAYERS_BLEND.art
  [default]_VolumeViz/horizons/horizonShift/horizonShiftProjection.art #3765

  #OIV-2306 shape merging issue following driver update
  [default]_VolumeViz/voxelizedRendering/outlineThreshold.art

  ############################################################################
  # Ebugs
  ############################################################################
  [default]_56911_ivGlewIsInitialized
  [default]_Ebugs_9.1/C++/4416/TestCase/4416_OIV_QuadMesh.art #54185
  [default]_Ebugs_8.1/C++/2874/TestCase/art433C.art #63584
  [default]_Ebugs_8.0.1/C++/2709/TestCase/05_2_IndexedFaceSet_2709_exe_art76B.art #65371
  [default]_Ebugs_8.0.2/C++/2885/TestCase/simpleVolume2885_exe_art9C7A.art #65372 slicing artefacts
  [default]_Ebugs_8.1/C++/1336/TestCase/SceneViewer_exe_art527.art #54177
  [default]_Ebugs_8.1/C++/2896/TestCase/SceneViewer_exe_art3F8.art #65374 texture issue
  [default]_Ebugs_9.4.1/C++/31428/TestCase/VOX_Reader_Endianess_test.art
  [default]_Ebugs_8.0/C++/2599/TestCase/MFCSDI2599_exe_art598.art #57773 not supported at all on AMD.
  )
endif()

if( GPU_NAME MATCHES "Quadro" )
  SET(CTEST_CUSTOM_TESTS_IGNORE
  ${CTEST_CUSTOM_TESTS_IGNORE}

  ############################################################################
  # Demos
  ############################################################################
  RUN_VertexAttribFeedback
  RUN_medicalDentalAutomaticPanoramic

  ############################################################################
  # UnitTests
  ############################################################################
  RUN_LDMprefetchTiles_CpuUnitTest
  [default]_modifyFSAAQuality
  [default]_markerSetBboxTest
  [default]_QtFSAA_test
  RUN_PDF_bug32503
  RUN_PDF_bug29436_1 #random
  RUN_PDF_bug29436_2 #random
  [default]_ProfileManagementTestFXAA_ON
  [default]_ProfileManagementTestFXAA_OFF
  [default]_ProfileManagementRenderingTestFXAA_OFF

  ############################################################################
  # Ebugs
  ############################################################################
  [default]_Ebugs_9.1/C++/4412/TestCase/4412_TextBoundingbox.art
  [default]_Ebugs_9.4.1/C++/30985/TestCase/VOX_Reader_test.art
  [default]_Ebugs_9.4.1/C++/31428/TestCase/VOX_Reader_Endianess_test.art
  )
endif()

# RTX "Quadro" cards
if(GPU_NAME MATCHES "RTX" AND NOT GPU_NAME MATCHES "GeForce")
  SET(CTEST_CUSTOM_TESTS_IGNORE ${CTEST_CUSTOM_TESTS_IGNORE}

  ############################################################################
  # UnitTests
  ############################################################################
  [default]_ProfileManagementTestFXAA_ON
  [default]_ProfileManagementTestFXAA_OFF
  [default]_ProfileManagementRenderingTestFXAA_OFF
  )
endif()

# NVIDIA "Turing" cards
if(GPU_NAME MATCHES "NVIDIA T" )
  SET(CTEST_CUSTOM_TESTS_IGNORE ${CTEST_CUSTOM_TESTS_IGNORE}

  ############################################################################
  # UnitTests
  ############################################################################
  [default]_ProfileManagementTestFXAA_ON
  [default]_ProfileManagementTestFXAA_OFF
  [default]_ProfileManagementRenderingTestFXAA_OFF
  [default]_QWidgetOverRenderArea_test # Bug OIV-4148
  [default]_SubdividedTile
  )
endif()

if( GPU_NAME MATCHES "GeForce" )
  SET(CTEST_CUSTOM_TESTS_IGNORE
  ${CTEST_CUSTOM_TESTS_IGNORE}

  ############################################################################
  # Demos
  ############################################################################

  ############################################################################
  # UnitTests
  ############################################################################
  [default]_VolumeViz/voxelOutline/HFROutlineDisabled.art
  [default]_TextPerformances_Text3_TEXTURE_Simple_OIV10B3 #45582
  [default]_TextPerformances_Text3_TEXTURE_Billboard_OIV10B3 #45582
  [default]_ProfileManagementTestFXAA_ON
  [default]_ProfileManagementTestFXAA_OFF
  [default]_ProfileManagementRenderingTestFXAA_OFF

  ############################################################################
  # Ebugs
  ############################################################################
  [default]_oiv-1435-converter_crash
  [default]_Ebugs_8.0/C++/2599/TestCase/MFCSDI2599_exe_art598.art
  [default]_Ebugs_9.7.0/C++/54482/hfr_undef_value.art
  [default]_Ebugs_9.3.2/C++/28708/TestCase/RGBA_SoVolumeData_test.art

  ############################################################################
  # Random
  ############################################################################
  [default]_MultithreadBufferObject
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRender2UndefNode/undefinedNode1.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRlargeTile/largeTile.art
  [default]_QtHelloCone2025
  )
endif()

# AMD Radeon specific issues. #65812
if( GPU_NAME MATCHES "Radeon" )
  SET(CTEST_CUSTOM_TESTS_IGNORE
  ${CTEST_CUSTOM_TESTS_IGNORE}

  ############################################################################
  # Demos
  ############################################################################
  [default]_Inventor/AlgebraicShape/AlgebraicShapesClipPlane.art #68845

  ############################################################################
  # UnitTests
  ############################################################################
  databaseChecker
  databaseCheckerAction
  [default]_modifyFSAAQuality
  [default]_markerSetBboxTest
  [default]_Inventor/Environment/fogTypes.art
  RUN_letterSpacingUnitTest_CpuUnitTest
  [default]_QtFSAA_test
  [default]_TextureImageProperties
  [default]_DICOMLoadingTest_nofile_loadInMemory
  [default]_DICOMLoadingTest_missingFileNumbers_folder

  ############################################################################
  # Ebugs
  ############################################################################
  [default]_Ebugs_8.0/C++/2400/TestCase/volRend_exe_art8E9.art
  [default]_Ebugs_9.4.1/C++/30985/TestCase/VOX_Reader_test.art

  ############################################################################
  # Random
  ############################################################################
  RUN_medicalDentalAutomaticPanoramic
  [default]_intersectionMap_SoVolumeIndexedFaceSet
  )
endif()

# AMD Firepro specific issues. #65812
if( GPU_NAME MATCHES "FirePro" )
  SET(CTEST_CUSTOM_TESTS_IGNORE
  ${CTEST_CUSTOM_TESTS_IGNORE}

  ############################################################################
  # Demos
  ############################################################################
  [default]_Medical/Rendering/Techniques/medicalSimpleShadows/simpleShadows_exe_artC0C8.art

  RUN_10.6.PickFilterTopLevel
  RUN_10.8.PickFilterNodeKit
  RUN_shadersBrowser
  RUN_AnalysisCharts
  RUN_medicalGetDataBox
  RUN_medicalGetDataBox_multiThread
  RUN_medicalGetDataLine
  RUN_medicalGetDataPlane
  RUN_medicalGetDataPolyLine
  RUN_2DTransferFunction
  RUN_ComputeSlice
  RUN_getDataBox
  RUN_getDataLine
  RUN_getDataPlane
  RUN_getDataPolyLine
  RUN_getDataTrace
  RUN_getDataBox_multiThread
  RUN_DataAccessCustomReader

  ############################################################################
  # UnitTests
  ############################################################################
  [default]_Inventor/AlgebraicShape/AlgebraicShapesClipPlane.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRPropertyMask/propertyMask.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRlargeTile/largeTile.art
  [default]_VolumeViz/voxelOutline/HFROutlineDisabled.art
  [default]_Turbine_RayPicking
  RUN_SimpleVertexAttribFeedback
  RUN_medical2DTransferFunction
  RUN_TransferFunction2D
  [default]_VolumeViz/isoSurface/isoSurface.art
  [default]_TextureImageProperties
  [default]_VolumeViz/orthoSlices/bigImageOrthoSlice.art

  ############################################################################
  # Ebugs
  ############################################################################
  [default]_Ebugs_9.0/C++/3382/TestCase/3382_AbnormalClip_exe_art3E21.art
  [default]_QtHelloCone2025
  [default]_2712_mt_intec

  ############################################################################
  # Random
  ############################################################################
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRender2UndefNode/undefinedNode1.art
  [default]_Ebugs_9.2.4/C++/17542/TestCase/17542_BorderArtefacts_VolumeRender.art
  [default]_Ebugs_9.7.0/C++/54482/hfr_undef_value.art

  ############################################################################
  # MolViz
  ############################################################################
  [default]_MolViz/tests/bug46691.art #OIV-2286
  [default]_MolViz/tests/fog_soenvironment_in_haze_mode.art #OIV-2286
  )
endif()

# INTEL specific issues. #65906
if( GPU_NAME MATCHES "HD Graphics" )
  SET(CTEST_CUSTOM_TESTS_IGNORE
  ${CTEST_CUSTOM_TESTS_IGNORE}

  ############################################################################
  # Demos
  ############################################################################
  [default]_Medical/Rendering/Techniques/medicalSimpleShadows/simpleShadows_exe_artC0C8.art #66068
  [default]_VolumeViz/getLDMData/art2747.art # Timeout
  [default]_VolumeViz/getLDMData/artA6C3.art # Timeout

  #OIV-4455 UHD770 issues
  [default]_Medical/Rendering/Visualization/medicalSimpleIsosurface/medicalSimpleIsosurface_exe_art653F.art
  [default]_VolumeViz/editing/editingFeature/art159E.art
  [default]_VolumeViz/simpleVolumeMask/simpleVolumeMaskart1jttGe.art

  ############################################################################
  # UnitTests
  ############################################################################
  [default]_Inventor/drawStyle/drawStyle.art # wrong lineWidth
  [default]_Inventor/AlgebraicShape/AlgebraicShapesClipPlane.art
  [default]_VolumeViz/orthoSlices/bigImageOrthoSlice.art

  [default]_CheckIvShape-BufferedLINES
  [default]_CheckIvShape-BufferedPOINTS
  [default]_CheckIvShape-BufferedLINE_LOOP
  [default]_CheckIvShape-IndexedBufferedLINE_STRIP
  [default]_CheckIvShape-IndexedBufferedQUAD_STRIP
  [default]_CheckIvShape-IndexedBufferedPOINTS

  [default]_Elemtool3554_RayPicking
  [default]_Elemtool4066_RayPicking
  [default]_Turbine_RayPicking
  [default]_Elemtool4801_RayPicking
  [default]_bug23482_RayPicking
  [default]_LineSet100_100_RayPicking
  [default]_FaceSet_4_100_100_RayPicking
  [default]_IndexedTriangleSet100_100_RayPicking
  [default]_IndexedTriangleStripSet100_100_RayPicking
  [default]_IndexedFaceSet_4_100_100_RayPicking

  [default]_pickingVolumeGpu_DICOM_43682
  [default]_TextureImageProperties
  [default]_DICOMLoadingTest_nofile_loadInMemory

  #OIV-2309 shape merging issue following driver update
  [default]_CheckIvShape-IndexedBufferedPOLYGON
  [default]_CheckIvShape-IndexedPRBufferedTRIANGLE_STRIP
  [default]_PerfoOM_RayPicking
  [default]_intersectionMap_SoVolumeIndexedFaceSet
  [default]_intersectionMap_SoVolumeFaceSet
  [default]_intersectionMap_SoVolumeIndexedTriangleStripSet
  [default]_intersectionMap_SoVolumeTriangleStripSet

  #OIV-4455 UHD770 issues
  [default]_Inventor/Antialiasing/art9E_ACCUM.art
  [default]_VolumeViz/FS_Geobody/FS_Editing/FS_Editing_Voxelizer/ebug5035.art
  [default]_VolumeViz/lighting/lighting_volumeRenderer.art
  [default]_GPUPicking_perf_ifso

  [default]_LegacyShaderConverter_BaseTest
  RUN_Text2_bugOIV5040_VieweportDependency_CpuUnitTest 

  ############################################################################
  # Ebugs
  ############################################################################
  [default]_2712_mt_intec

  #OIV-2309 shape merging issue following driver update
  [default]_Ebugs_9.6.3/C++/54389/TestCase/MultipleInstance-Single-Instance_Test.art

  #OIV-4453 UHD770 issue
  [default]_Ebugs_8.6/C++/3639/TestCase/3639_voxel_size_exe_art15B9.art

  ############################################################################
  # Random
  ############################################################################
  [default]_CheckIvShape-BufferedTRIANGLE_FAN
  [default]_CheckIvShape-BufferedPOLYGON
  [default]_CheckIvShape-BufferedLINE_STRIP
  [default]_CheckIvShape-IndexedBufferedLINE_LOOP
  [default]_CheckIvShape-BufferedQUAD_STRIP
  [default]_CheckIvShape-IndexedBufferedLINES
  [default]_CheckIvShape-IndexedBufferedTRIANGLE_FAN
  [default]_CheckIvShape-IndexedPRBufferedLINE_STRIP
  [default]_CheckIvShape-IndexedPRBufferedQUAD_STRIP
  )
endif()

if( GPU_NAME MATCHES "AMD" OR GPU_NAME MATCHES "HD Graphics")
# Globally disabled test
SET(CTEST_CUSTOM_TESTS_IGNORE
  ${CTEST_CUSTOM_TESTS_IGNORE}

  ############################################################################
  # UnitTests
  ############################################################################
  [default]_TextPerformances_Text3_TEXTURE_Simple_OIV10B3 #45582
  [default]_TextPerformances_Text3_TEXTURE_Billboard_OIV10B3 #45582

  [default]_RemoteVizNoFrameBufferedUnitTest #OIV-3530
  )
endif()

# Tests disabled only on Windows
if (WIN32)
  SET(CTEST_CUSTOM_TESTS_IGNORE ${CTEST_CUSTOM_TESTS_IGNORE}

  ############################################################################
  # UnitTests
  ############################################################################
  [default]_MultithreadBufferObject # OIV-4407

  ############################################################################
  # Ebugs
  ############################################################################
  [default]_simple2580 # OIV-4405
  [default]_17562_VolumeViz_histogram_Crash_test # OIV-4406

  )
endif()

# Tests enabled only on Windows
if( NOT WIN32 )
  SET(CTEST_CUSTOM_TESTS_IGNORE
  ${CTEST_CUSTOM_TESTS_IGNORE}
  ############################################################################
  # Demos
  ############################################################################
  RUN_ivGLUT #66783
  RUN_17.1.ColorIndex
  RUN_GraphicConfig
  RUN_viewer
  RUN_twoDisplays
  RUN_vortex
  RUN_SlotCar
  [default]_VolumeViz/LargeSliceSupport/largeSliceSupport_orthoSlice.art

  ############################################################################
  # UnitTests
  ############################################################################
  [default]_VolumeViz/transferFunction/multidata_tf_different_size/multidata_tf_different_size.art

  [default]_Inventor/Antialiasing/artF0D6_ACCUM.art
  RUN_extSelectionLogicTest_CpuUnitTest #66769
  [default]_LightModelElement #66901
  RUN_OffScreenRenderAreaUnitTest_CpuUnitTest #66096
  [default]_PackedColorTransparency #66902
  [default]_Elemtool4066_RayPicking #66093
  [default]_Elemtool4620_RayPicking #66093
  [default]_Turbine_RayPicking
  RUN_cullingBug59056_CpuUnitTest #66773
  [default]_TextPerformances_Text3_TEXTURE_Simple
  [default]_TextPerformances_Text3_TEXTURE_Billboard
  RUN_LDMConverterOptim_CpuUnitTest #66097
  RUN_SoHeightFieldDetail_CpuUnitTest
  [default]_TextBigTestSuite_Text3TexQuality #random
  [default]_BufferedShape_Dynamic # OIV-4401
  [default]_LDM_Converter_bench_2-VOL2LDM-1  # OIV-4402
  [default]_LDM_Converter_bench_2-LDM2LDM-1  # OIV-4402
  [default]_LDM_Converter_bench_2-LDM2LDM-2  # OIV-4402
  [default]_LDM_Converter_bench_2-SEGY2LDM-1 # OIV-4402
  [default]_LDM_Converter_bench_2-SEGY2LDM-2 # OIV-4402
  [default]_LDM_Converter_bench_2-SEGY2LDM-3 # OIV-4402
  [default]_DICOMLoadingTest_multiFrame # OIV-4403
  [default]_DICOMLoadingTest_missingFileNumbers_folder # OIV-4403
  [default]_DICOMLoadingTest_simpleVolume_series # OIV-4403
  [default]_LDMCompressorTest_jp3d_uint32 #random
  RUN_QtContexts_CpuUnitTest # Timeout OIV-5246

  ############################################################################
  # Ebugs
  ############################################################################
  [default]_Ebugs_9.3.2/C++/28708/TestCase/RGBA_SoVolumeData_test.art #OIV-1701
  [default]_Ebugs_8.1/C++/2607/TestCase/simpleVolume_2607_exe_art15B.art
  [default]_Ebugs_8.1/C++/2874/TestCase/art433C.art
  [default]_Ebugs_8.1/C++/2877/TestCase/2877_Fraps_Test_exe_art311.art
  [default]_Ebugs_8.1/C++/2969/TestCase/SceneViewer_exe_artB149.art
  [default]_Ebugs_9.3.1/C++/17613/TestCase/17613_SoText3_TrueType_Chars_font_test.art
  [default]_LDMWrite2583
  [default]_Ebugs_7.2/C++/2330/TestCase/bugOrthoCam2330_exe_art14D.art
  [default]_Ebugs_8.0/C++/2329/TestCase/orthoCamClipPlanes/bugOrthoCam2329_exe_art1195.art
  [default]_Ebugs_9.1/C++/4475/TestCase/4475_OIV_CSGShape.art
  [default]_Ebugs_9.2.1/C++/4817/TestCase/4817_HorizonProbeSculptedTest2.art
  [default]_Test_44036 # OIV-4400
  [default]_3579_SoToPDFAction_Crash # OIV-4404

  ############################################################################
  # MolViz
  ############################################################################
  [default]_MolViz/tests/bug46691.art #OIV-2286
  [default]_MolViz/tests/fog_soenvironment_in_haze_mode.art #OIV-2286
  [default]_IsosurfaceViewer #OIV-2521
  )
endif()

# Ubuntu disabled tests
if( LINUX_PLATFORM MATCHES "Ubuntu" )
SET(CTEST_CUSTOM_TESTS_IGNORE
  ${CTEST_CUSTOM_TESTS_IGNORE}

  ############################################################################
  # UnitTests
  ############################################################################
  #OIV-2000: X11 BadWindow
  RUN_TileCachePolicyNONE_CpuUnitTest
  RUN_TileCachePolicyNOINMEMCOMP_CpuUnitTest
  RUN_TileCachePolicyINMEMCOMP_CpuUnitTest
  RUN_TileCachePolicyLOWRESONLY_CpuUnitTest
  RUN_TileCachePolicyALL_CpuUnitTest
  [default]_RTTReadBack

  databaseCheckerAction
  #OIV-1999: smlib issue
  [default]_Inventor/SoExtrusion/art2418.art
  [default]_Inventor/SoExtrusion/art44E.art
  [default]_Inventor/TransparencyTests/artB0EC_BLEND.art
  [default]_Inventor/TransparencyTests/artB0EC_DEAYED_BLEND.art
  [default]_Inventor/TransparencyTests/artB0EC_SORTED_LAYERS_BLEND_DEPTH_PEEL.art
  [default]_Inventor/TransparencyTests/artB0EC_SORTED_LAYERS_BLEND_KBUFFER_1P.art
  [default]_Inventor/TransparencyTests/artB0EC_SORTED_LAYERS_BLEND_KBUFFER_2P.art
  [default]_Inventor/TransparencyTests/artB0EC_SORTED_OBJECT_BLEND.art
  [default]_VolumeViz/FS_Geobody/FS_Probing/FS_Probe_surfaceCSG/circularExtrusionCSG.art

  #OIV-3972: crash
  extractScenesALPHA1

  ############################################################################
  # Ebugs
  ############################################################################
  #OIV-1999: smlib issue
  [default]_Ebugs_9.0/C++/4152/TestCase/4152_OIV_CSGShape_Console.art
  [default]_Ebugs_9.1/C++/4457/TestCase/CircularExtrusion_Clipping_4457.art
  [default]_Ebugs_9.1/C++/4475/TestCase/4475_OIV_CSGShape.art
  [default]_Ebugs_9.1/C++/4552/TestCase/4552_HorizonProbeSculptedTest.art
  [default]_Ebugs_9.2/C++/4719/4719_HorizonClippingLedgeTest2.art
  )
endif()

# GCC8 disabled tests
if( LINUX_PLATFORM MATCHES "CentOS 8" )
SET(CTEST_CUSTOM_TESTS_IGNORE
  ${CTEST_CUSTOM_TESTS_IGNORE}

  ############################################################################
  # UnitTests
  ############################################################################
  databaseCheckerAction
  #OIV-1999: smlib issue
  [default]_Inventor/SoExtrusion/art2418.art
  [default]_Inventor/SoExtrusion/art44E.art
  [default]_Inventor/SoExtrusion/art7A6E.art 
  [default]_Inventor/TransparencyTests/artB0EC_BLEND.art
  [default]_Inventor/TransparencyTests/artB0EC_DEAYED_BLEND.art
  [default]_Inventor/TransparencyTests/artB0EC_SORTED_LAYERS_BLEND_DEPTH_PEEL.art
  [default]_Inventor/TransparencyTests/artB0EC_SORTED_LAYERS_BLEND_KBUFFER_1P.art
  [default]_Inventor/TransparencyTests/artB0EC_SORTED_LAYERS_BLEND_KBUFFER_2P.art
  [default]_Inventor/TransparencyTests/artB0EC_SORTED_OBJECT_BLEND.art
  [default]_VolumeViz/FS_Geobody/FS_Probing/FS_Probe_surfaceCSG/circularExtrusionCSG.art

  #Random fails  (timeout or Segfault) see OIV-3168
  [default]_NodeTraversalActionsRenderTest
  [default]_intersectionMap_SoVolumeIndexedTriangleStripSet
  [default]_intersectionMap_SoVolumeFaceSet
  [default]_intersectionMap_SoVolumeIndexedFaceSet
  extractScenesALPHA1
  extractScenesRGBA1

  ############################################################################
  # Ebugs
  ############################################################################
  #OIV-1999: smlib issue
  [default]_Ebugs_9.0/C++/4152/TestCase/4152_OIV_CSGShape_Console.art
  [default]_Ebugs_9.1/C++/4457/TestCase/CircularExtrusion_Clipping_4457.art
  [default]_Ebugs_9.1/C++/4552/TestCase/4552_HorizonProbeSculptedTest.art
  [default]_Ebugs_9.2/C++/4719/4719_HorizonClippingLedgeTest2.art
  )
endif()


if( GPU_NAME MATCHES "AMD" OR GPU_NAME MATCHES "HD Graphics" OR NOT WIN32 )
SET(CTEST_CUSTOM_TESTS_IGNORE
  ${CTEST_CUSTOM_TESTS_IGNORE}

  ############################################################################
  # UnitTests
  ############################################################################
  [default]_antiAliasing
  )
endif()

#Detect bod593
if( CMAKE_ARCHITECTURE MATCHES "gcc7" AND GPU_NAME MATCHES "P2000")
  SET(CTEST_CUSTOM_TESTS_IGNORE
  ${CTEST_CUSTOM_TESTS_IGNORE}

  [default]_Inventor/Texturing/LargeTexture.art # Timeout
  )
endif()

# Detect TF-041975922094
if(WIN32 AND GPU_NAME MATCHES "HD Graphics" AND WINDOWS_VERSION GREATER_EQUAL 11)
  SET(CTEST_CUSTOM_TESTS_IGNORE
  ${CTEST_CUSTOM_TESTS_IGNORE}

  [default]_LDMLoadingTester # OIV-4711
  )
endif()

# MESA
if( GPU_NAME MATCHES "LLVM" )
  SET(CTEST_CUSTOM_TESTS_IGNORE
  ${CTEST_CUSTOM_TESTS_IGNORE}

  ############################################################################
  # Demos
  ############################################################################
  #Timeout #
  [default]_Inventor/Features/MultiInstancing/AlgebraicShapes/art5799.art
  [default]_Inventor/Features/MultiInstancing/AlgebraicShapes/art9CF2.art
  [default]_Inventor/Features/MultiInstancing/BufferedShapes/MultiInstance_BufferedShape.art
  [default]_Medical/Analysis/medicalCPUDataCompose/CPUDataCompose_exe_artC97B.art
  [default]_Medical/Analysis/medicalGPUDataCompose/GPUDataCompose_exe_artE5D1.art
  [default]_Medical/Rendering/VolumeTextureCompose_exe_art170.art
  [default]_Medical/Segmentation/medicalMarchingCubesSurface/marchingCubesSurface_exe_artEB6D.art
  [default]_Medical/TransferFunction/medicalMultiTransferFunctions/multiTransferFunctions_exe_artCB42.art
  [default]_VolumeViz/CSGClippingGroup/CSGClippingGroup_exe_art456A.art
  [default]_VolumeViz/edge2D/artutiZph.art
  [default]_VolumeViz/editing/editingFeature/art159E.art
  [default]_VolumeViz/horizonClipping/horizonClipping_exe_artA12F.art
  [default]_VolumeViz/multiChannel/multiChannel_ex1_exe_artDEC3.art
  [default]_VolumeViz/multiChannel/multiChannel_ex2_exe_art2556.art
  [default]_VolumeViz/multiData/CPUDataCompose/art4BD3.art
  [default]_VolumeViz/multiData/GPUDataCompose/art2B1B.art
  [default]_VolumeViz/multiData/VolumeTextureCompose/VolumeTextureCompose.art
  [default]_VolumeViz/segmentedInterpolation/segmentedInterpolationartWi2x7r.art
  [default]_VolumeViz/simpleInteractiveParameters/art3dvwzf.art
  [default]_VolumeViz/simpleInteractiveParameters/artE17F.art
  [default]_VolumeViz/simpleLightedVolume/artJtxTzC.art
  [default]_VolumeViz/simpleShadows/artjF7vPp.art
  [default]_VolumeViz/simpleVolumeMask/simpleVolumeMaskart1jttGe.art
  [default]_VolumeViz/volumeDataDrawStyle/volumeDataDrawStyleartg3fM19.art
  [default]_Medical/Rendering/Techniques/medicalEdge2D/edge2D_exe_artBC80.art
  [default]_VolumeViz/editing/editingExtrusion/art1511.art
  [default]_VolumeViz/horizonClipping/horizonClipping_exe_artBCFE.art
  [default]_VolumeViz/simpleInteractiveParameters/art517D.art
  [default]_VolumeViz/simpleIsosurface/art5F40.art
  [default]_VolumeViz/surfaceScalar/arttSWpky.art
  # 2 timeouts (happens on the machine after a reboot)
  RUN_dialogTutorial01
  RUN_simple3DMenu

  # TesselationShader OIV-3931 #
  [default]_Inventor/Features/Shaders/SimplePassthrough/SimplePassthrough.art
  [default]_VolumeViz/multiData/horizonGpuCompose/artD2FE.art
  [default]_VolumeViz/simpleHorizon/art77A.art
  [default]_VolumeViz/simpleHorizonRGBA/HFRrgbaTESS.art

  # Shader conversion
  [default]_LegacyShaderConverter_BaseTest
  [default]_LegacyShaderConverter_SlbTest

  #Misc
  [default]_Inventor/Features/Shaders/GeometryShader/GeometryShader.art
  [default]_VolumeViz/Machining/artO9U6NV.art

  ############################################################################
  # UnitTests
  ############################################################################
  # TesselationShader OIV-3931 #
  [default]_VolumeViz/ResourceManager/hfr/simpleHFRRessource.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/17628/edgesSealed.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/5166/testShadows.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/5179/testUniformProperty.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFR1ConvertedUnitTests/horizon/HFRhorizon.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFR1ConvertedUnitTests/horizon/HFRhorizonInMemory.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFR1ConvertedUnitTests/horizon/HFRvsg.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFR1ConvertedUnitTests/horizon/HFRvsgInMemory.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFR1ConvertedUnitTests/horizon/horizon1.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFR1ConvertedUnitTests/horizon/horizon2.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFR1ConvertedUnitTests/horizon/horizon3.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFR1ConvertedUnitTests/horizonConverter/blendTransparency.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFR1ConvertedUnitTests/horizonConverter/shapeHintClockwise.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFR1ConvertedUnitTests/horizonConverter/shapeHintClockwise2.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFR1ConvertedUnitTests/horizonConverter/shapeHintOff.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFR1ConvertedUnitTests/horizonGpuCompose/horizonGpuCompose.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFR1ConvertedUnitTests/horizonShadow/HFRshadow.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFR1ConvertedUnitTests/horizonShadow/debugShadowGroup.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRAndBufferedShape/HFRAndBufferedShape.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRAndBufferedShape/HFRAndBufferedShapeWithAmbientDiffSpec.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRClipPlane/clipPlane.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRGPUbbox/HFRender2GPUbbox.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRGeometryAsProperty/HFRGeometryAsProperty.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRLighting/lighting.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRLighting/lowResLighting.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRLowRes/lowRes.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRMaxResolution/HFRMaxResolution.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRMultiHeightField/HFRMultiHeightField.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRMultiTiled/HFRMultiTiledMask.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRMultiTiled/HFRMultiTiledMaskTileClipped.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRMultiTiled/HFRMultiTiledProperty.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRMultiTiled/HFRMultiTiledPropertyTileClipped.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRNoProperty/HFRNoProperty.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRPropertyMask/propertyMask.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRPropertyMask/propertyMask41978.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRPropertyMask/propertyMaskOnOff.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRRoiClipping/roiClipping.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRScales/scale.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRSpecificDataDim/HFR1x1.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRSpecificDataDim/HFRSpecificDataDim.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRSpecificDataDim/HFRSpecificDataDim2.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRSwitchTextures/switchHeightTexture.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRSwitchTextures/switchMaskTexture.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRSwitchTextures/switchPropertyTexture.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRTransparency/transparency.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRTransparency/transparency2.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRender2BBox/HFRender2BBox.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRender2Extent/HFRender2Extent.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRender2TriangleNumber/HFRender2Triangles.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRender2TriangleOrientation/HFRender2TrianglesOrientation.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRender2UndefCell/HFRender2UndefCell.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRender2UndefNode/HFR60x60withUndef.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRender2UndefNode/HFRender2UndefNode.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRender2UndefNode/undefinedNode1.art
  [default]_VolumeViz/VeryLargeHorizonViz/private/UnitTestsHFR/HFRlargeTile/largeTile.art
  [default]_VolumeViz/gridClipping/HFRGridClipping.art
  [default]_VolumeViz/horizons/horizon/art6B1.art
  [default]_VolumeViz/horizons/horizon/artBA17.art
  [default]_VolumeViz/horizons/horizon/artCE43.art
  [default]_VolumeViz/horizons/horizon/horizonDifferentTileSizes.art
  [default]_VolumeViz/horizons/horizon/horizonExtent.art
  [default]_VolumeViz/horizons/horizon/horizonFloat.art
  [default]_VolumeViz/horizons/horizon/horizonInVolume.art
  [default]_VolumeViz/horizons/horizon/horizonReload.art
  [default]_VolumeViz/horizons/horizonConverter/art2DC9.art
  [default]_VolumeViz/horizons/horizonConverter/horizonsartOFk4Ul.art
  [default]_VolumeViz/horizons/horizonConverter/horizonsartbo3Zlv.art
  [default]_VolumeViz/horizons/horizonConverter/horizonsartez59iX.art
  [default]_VolumeViz/horizons/horizonShadow/shadowsHorizonartODpgfL.art
  [default]_VolumeViz/horizons/horizonShift/horizonShiftProjection.art
  [default]_VolumeViz/lighting/lighting_horizon.art
  [default]_VolumeViz/raycastTransparency/artFiles/DELAYED_BLEND/art2535_DELAYED_BLEND.art
  [default]_VolumeViz/raycastTransparency/artFiles/DELAYED_BLEND/art4755_DELAYED_BLEND.art
  [default]_VolumeViz/raycastTransparency/artFiles/DELAYED_BLEND/artADC5_DELAYED_BLEND.art
  [default]_VolumeViz/raycastTransparency/artFiles/DELAYED_SORTED_LAYERS_BLEND/art4755_DELAYED_SORTED_LAYERS_BLEND.art
  [default]_VolumeViz/raycastTransparency/artFiles/DELAYED_SORTED_LAYERS_BLEND/artADC5_DELAYED_SORTED_LAYERS_BLEND.art
  [default]_VolumeViz/raycastTransparency/artFiles/SORTED_OBJECT_BLEND/art4755_SORTED_OBJECT_BLEND.art
  [default]_VolumeViz/raycastTransparency/artFiles/SORTED_OBJECT_BLEND/artADC5_SORTED_OBJECT_BLEND.art
  [default]_VolumeViz/texCoord/horizon.art
  [default]_VolumeViz/transparency/customShaderTransparency.art
  [default]_VolumeViz/voxelOutline/HFROutlineDisabled.art
  [default]_Inventor/Shaders/TessellationShaders/TessShaderBufferedShape.art
  [default]_Inventor/Shaders/TessellationShaders/TessShaderIndexedBufferedShape.art
  [default]_Inventor/Shaders/TessellationShaders/TessShaderIndexedPointSet.art
  [default]_Inventor/Shaders/TessellationShaders/TessShaderPointSet.art
  [default]_Inventor/Shaders/TessellationShaders/TessShader_patchsize_4_frag.art
  [default]_horizonShiftPicking
  [default]_HeightFieldDepthOffset
  [default]_HFROutlineShaderNoCacheBreak
  [default]_RayPick_OIV2126_test
  [default]_Inventor/multiinstance/MultiInstancePassthroughCE_.art
  [default]_Inventor/multiinstance/MultiInstanceTessellationPassthrough.art
  [default]_VolumeViz/horizons/horizon/horizonOutline.art
  [default]_VolumeViz/lighting/pbs_horizon.art

  # Timeout #
  [default]_VolumeViz/gridClipping/art61E1_linearUndef.art
  [default]_VolumeViz/gridClipping/horizon_holes.art
  [default]_VolumeViz/isoSurface/isoSurface.art
  [default]_VolumeViz/MultiData/MultiDimensions/VolumeRender/MultiVolumeRender_2Dims.art
  [default]_VolumeViz/opaqueObject/art859D.art
  [default]_VolumeViz/physicalRendering/physicalRendering.art
  [default]_VolumeViz/shadows/shadowVviz.art
  [default]_VolumeViz/transferFunction/art86A5.art
  [default]_VolumeViz/virtualTexture/simpleLightedVolumearto2rQaT.art
  [default]_VolumeViz/FS_Geobody/FS_Editing/FS_Editing_DataTransform/shapeDT/art2BBD.art
  [default]_VolumeViz/FS_Geobody/FS_Editing/FS_Editing_DataTransform/subVolumeDT/art96FD.art
  [default]_VolumeViz/FS_Geobody/FS_Editing/FS_Editing_EditingStack/artB131.art
  [default]_VolumeViz/FS_Geobody/FS_Editing/FS_Editing_Voxelizer/art4005.art
  [default]_VolumeViz/FS_Geobody/FS_Editing/FS_Editing_Voxelizer/art4006.art
  [default]_VolumeViz/ambientOcclusion/ambientOcclusionTransparency.art
  [default]_VolumeViz/dataRange/medicalFoot.art
  [default]_VolumeViz/gridClipping/art1EF3_UniformGridClippingInterpolationTest.art
  [default]_VolumeViz/isoSurface/VolumeIsosurfaceSwitch.art
  [default]_VolumeViz/isoSurface/isoSurfaceLighting.art
  [default]_VolumeViz/volumeMask/volumeMaskartUTDmVf.art
  [default]_LDM_BufferObjectCache_bench-TRACE
  [default]_intersectionMap_SoVolumeIndexedFaceSet
  [default]_intersectionMap_SoVolumeFaceSet
  [default]_intersectionMap_SoVolumeIndexedTriangleStripSet
  [default]_intersectionMap_SoVolumeTriangleStripSet
  [default]_Inventor/Texturing/LargeTexture.art

  # RemoteViz #
  [default]_RemoteVizH264UnitTest
  [default]_RemoteVizNoFrameBufferedUnitTest

  #OIV-3935
  [default]_customPresentFrame

  #Undef voxel OIV-3793
  [default]_UndefinedVoxel_test
  [default]_VolumeViz/interpolation/interpolationCubicLabels.art

  #Grid Clipping issue OIV-3936
  [default]_VolumeViz/gridClipping/undefinedValue_ROI.art

  #ANTIALIASING OIV-3932
  [default]_Inventor/Antialiasing/smoothing.art
  [default]_modifyFSAAQuality
  [default]_AntialiasingManualParamsTest
  [default]_QtFSAA_test

  #MISC
  [default]_VolumeViz/multiViewerContext/art6804_notShared.art
  [default]_Inventor/drawStyle/drawStyle.art # antialiasing ?
  [default]_VolumeViz/volumeGroup/OIVValidation_VolumeGroupeTest3.art # csgshape, opcatityCorrection ... ?
  [default]_CheckIvShape-IndexedPRBufferedTRIANGLE_STRIP
  RUN_NodeDependencies_test_CpuUnitTest
  [default]_logicOperationElement_test
  [default]_HDPIViewer
  [default]_SubdividedTile
  RUN_Text2_bugOIV5040_VieweportDependency_CpuUnitTest

  # ComputeShaders
  [default]_Inventor/Shaders/ComputeShaders/SimpleComputeShader.art

  #Randoms
  [default]_fastEditStereo

  [default]_VVizIvTest_RgbTiff # OIV-4408

  # CubeMap + ImageParam + Float format
  [default]_Inventor/ToneMapping/ToneMapping_RenderToTextureCube.art

  # RenderEngine tests with no rendering
  [default]_DaphnisTest
  [default]_atlas
  [default]_multiSample_pandoraGL_8
  [default]_multiSample_pandoraGL_16
  [default]_multiSample_pandoraGL_32
  [default]_CopyBuffer

  ############################################################################
  # Ebugs
  ############################################################################
  #Timeout #
  [default]_Ebugs_8.0/C++/2538/TestCase/IvTuneViewer_exe_art4B05.art
  [default]_Ebugs_9.0/C++/3937/TestCase/3937_TranspRendering_exe_artF2F8.art
  [default]_Ebugs_9.0/C++/3944/TestCase/IvTuneViewer_exe_artE3AB.art
  [default]_Ebugs_9.1/C++/4527/TestCase/4527_ObliqueSlice_Artifacts.art
  [default]_Ebugs_9.2.2/C++/17154/TestCase/17154_PerkinElmer_Isosurface_Artefacts.art
  [default]_Ebugs_9.2.3/C++/4976/TestCase/4976_boundaryAlligned_Transparency.art
  [default]_Ebugs_9.3.1/C++/23469/TestCase/23469_CubicInterpolation_Rendering.art
  [default]_Ebugs_8.1/C++/2891/TestCase/2891_simpleVolume_exe_art8FA.art

  # TesselationShader OIV-3931 #
  [default]_Ebugs_8.1/C++/2898/TestCase/2898_simpleHorizon_exe_art420.art
  [default]_Ebugs_8.1/C++/2899/TestCase/2899_simpleHorizon_exe_art47B.art
  [default]_Ebugs_8.1/C++/2904/TestCase/2904_simpleHorizon2side_exe_artB293.art
  [default]_Ebugs_8.1/C++/2942/TestCase/2942_TestGPUDipAzimuth_exe_art6B4.art
  [default]_Ebugs_8.1/C++/2951/TestCase/simpleVvizViewer_exe_artB4E.art
  [default]_Ebugs_8.1/C++/2951/TestCase/simpleVvizViewer_exe_artB4F.art
  [default]_Ebugs_8.1/C++/2962/TestCase/2962_simpleHorizon_exe_art82A.art
  [default]_Ebugs_8.5/C++/3460/TestCase/3460_SoHeightFieldRender_exe_art9E6A.art
  [default]_Ebugs_8.5/C++/3461/TestCase/3461_RenderingChanged_exe_art72B2.art
  [default]_Ebugs_9.3/C++/5242/TestCase/5242_Tesselation_Shader_Test.art
  [default]_Ebugs_9.4.0/C++/17564/TestCase/17564_HeightFieldRender_ClipPlane_Computation.art
  [default]_Ebugs_9.4.0/C++/17597/TestCase/17597_HeightFieldRender_Surface_culling.art
  [default]_Ebugs_9.4.0/C++/17649/TestCase/17649_HeightFieldRender_UniformGridClipping.art
  [default]_Ebugs_9.4.0/C++/17661/TestCase/17661_HeightFieldRender_Undefined_Nodes.art
  [default]_Ebugs_9.4.0/C++/17687/TestCase/17687_HeightFieldRender_tessellation_cracks.art
  [default]_Ebugs_9.4.0/C++/24006/TestCase/24006_HeightFieldRender_geometry_cropped.art
  [default]_Ebugs_9.4.0/C++/28421/TestCase/28421_HeightFieldRender_Cracks_test.art
  [default]_Ebugs_9.7.0/C++/54482/hfr_undef_value.art
  [default]_Ebugs_9.X/C++/oiv-541/hrf_gridclipping.art
  [default]_Ebugs_9.3.1/C++/17645/TestCase/17645_VolumeRendering_HeightField.art

  #MISC
  [default]_Ebugs_7.1/C++/1229/TestCase/whiteGeom1229_exe_art17CF.art
  [default]_Ebugs_8.1/C++/1925/TestCase/SceneViewer_exe_artE6B.art # red line in directViz
  [default]_Ebugs_8.1/C++/2896/TestCase/SceneViewer_exe_art3F8.art
  [default]_Ebugs_8.5/C++/3333/TestCase/SceneViewer_exe_art6F81.art
  [default]_Ebugs_8.5/C++/3362/TestCase/3362_SoBufferedShape_Bbox_Test_exe_artA8A8.art

  #Grid Clipping issue OIV-3936
  [default]_Ebugs_9.2.2/C++/4923/TestCase/4923_Probe_Color_CycleIssue.art
  [default]_Ebugs_9.2/C++/4684/TestCase/4684_BoundaryAlign_gridClipping.art

  [default]_3354_CrashTest # OIV-4399

  )
endif()

# Globally disabled test
SET(CTEST_CUSTOM_TESTS_IGNORE
  ${CTEST_CUSTOM_TESTS_IGNORE}

  [default]_TextPerformances_Text3_POLYGON_Simple #45582
  [default]_TextPerformances_Text3_POLYGON_Billboard #45582
  [default]_TextPerformances_Text3_TEXTURE_Simple #45582
  [default]_TextPerformances_Text3_TEXTURE_Billboard #45582

  [default]_pickingVolumeGpu_DICOM_44083

  [default]_66983_SoText_Memory_Leak

  [default]_horizonShiftLoading # Unstable results on all machines
  [default]_VolumeViz/horizons/horizon/horizonInVolume.art # Unstable results on all machines
  [default]_VolumeViz/MultiData/thinVolume/thinVolumeMixedTileSize.art # Unstable results on all machines

  [default]_QtMoleculeViewer # MolViz test too long

  # Unstable benches results on all machines
  [default]_largeSceneGraphTest_medium_model_1
  [default]_largeSceneGraphTest_withSep
  [default]_largeSceneGraphTest_benchmarkFaceSet
  [default]_largeSceneGraphTest_GIS

  [default]_QWidgetOverRenderArea_test # /OIV-4148
)


####################################################################################################
# UNSTABLE TESTS
####################################################################################################
SET(CTEST_CUSTOM_TESTS_IGNORE
${CTEST_CUSTOM_TESTS_IGNORE}

#STEP 1  - TASK OIV-4077
[default]_69620_DialogViz_ThreadSafety #OIV-4089
[default]_texLoadRate_bug40140 #OIV-4080
[default]_testCADReader-ungx #OIV-4081
[default]_Ebugs_9.2.2/C++/4923/TestCase/4923_Probe_Color_CycleIssue.art #OIV-4082
[default]_Inventor/SoExtrusion/art7A6E.art #OIV-4083
[default]_NodeTraversalActionsRenderTest #OIV-4084
[default]_Ebugs_9.X/C++/oiv-541/hrf_gridclipping.art #OIV-4090
[default]_depth_peeling_crash #OIV-4093
RUN_DicomReader_CpuUnitTest #OIV-4094
[default]_PerfoOM_RayPicking #OIV-4095
[default]_PerfoOMDouble_RayPicking #OIV-4099
[default]_VolumeViz/isoSurface/isoSurface.art #OIV-4100
[default]_Ebugs_9.0/C++/3940/TestCase/IvTuneViewer_exe_art3EE4.art #OIV-4103
[default]_Inventor/testVRMLFormat/ARTScenario/RampMaterial.wrl.art #OIV-4105
RUN_UndefinedVoxel #OIV-4107
RUN_bonesMuscles #OIV-4108
[default]_oiv-1435-converter_crash #OIV-4109
[default]_RemoteVizMainUnitTest #OIV-4111

#STEP 2 - OIV-4121
#Demos
[default]_Medical/Rendering/Techniques/medicalEdge2D/edge2D_exe_artBC80.art # OIV-4122
RUN_medicalDentalCurveUnfolding # OIV-4123
RUN_medicalImageSegmentationFloodFill # OIV-4124
RUN_medicalEdge2D # OIV-4125
RUN_medicalDTIViewer # OIV-4126
#UnitTests
[default]_fastEditStereo # OIV-4130
[default]_VolumeViz/volumeGeometry/normBindings/TriangleStripSet/volGeom-normBinding-TriangleStripSet.art # OIV-4142
[default]_intersectionMap_SoVolumeTriangleStripSet # OIV-4143
[default]_testCADReader-solidworks-1 # OIV-4144
[default]_VolumeViz/DICOMLoading/DICOM_UnloadReload.art # OIV-4145

#STEP 3 - OIV-4185
#UnitTests
[default]_ColorMaskElement # OIV-4186

)

