#Define GIT_EXE and the current branch as "GIT_BRANCH_NAME"
IF(NOT GIT_EXE)
	FIND_PROGRAM(GIT_EXE
	    NAMES git git.exe
	    PATHS bin $ENV{PROGRAMFILES}/Git  $ENV{ProgramW6432}/Git
	    PATH_SUFFIXES bin
	    DOC "Git executable"
	    )
endif()

set(OivSuite_SOURCE_DIR ${CMAKE_SOURCE_DIR})
if(BUILDING_EBUGS)
  set(OivSuite_SOURCE_DIR ${OivSuite_SOURCE_DIR}/..)
endif()
 
#Branch shaid
set(GIT_BRANCH_SHAID "")
execute_process( COMMAND ${GIT_EXE} rev-parse HEAD
                 WORKING_DIRECTORY ${OivSuite_SOURCE_DIR}
                 RESULT_VARIABLE GIT_RES
                 OUTPUT_VARIABLE GIT_BRANCH_SHAID
                 OUTPUT_STRIP_TRAILING_WHITESPACE
                 )

#Branch name

execute_process( COMMAND ${GIT_EXE} rev-parse --symbolic-full-name  HEAD
                 WORKING_DIRECTORY ${OivSuite_SOURCE_DIR}
                 RESULT_VARIABLE GIT_RES
                 OUTPUT_VARIABLE GIT_OUT
                 OUTPUT_STRIP_TRAILING_WHITESPACE
                 )
set(GIT_BRANCH_NAME "")
if(NOT GIT_RES)
  string(REGEX REPLACE "refs/heads/" "" GIT_BRANCH_NAME_WITH_PATH "${GIT_OUT}")
  string(REGEX REPLACE "/" "_" GIT_BRANCH_NAME "${GIT_BRANCH_NAME_WITH_PATH}")
  string(REGEX REPLACE "#" "" GIT_BRANCH_NAME "${GIT_BRANCH_NAME}")
  string(REGEX REPLACE "refs/heads/[a-z]+/([a-z]+[0-9]+)/.*" "\\1" GIT_TARGET_BRANCH_NAME "${GIT_OUT}")
endif()

set(CDASH_BRANCH_NAME "")
if(NOT GIT_RES)
  string(REGEX REPLACE "refs/heads/" "" CDASH_BRANCH_NAME "${GIT_OUT}")
  string(REGEX REPLACE "/" "" CDASH_BRANCH_NAME "${CDASH_BRANCH_NAME}")
  string(REGEX REPLACE "#" "" CDASH_BRANCH_NAME "${CDASH_BRANCH_NAME}")
  if(NOT CDASH_BRANCH_NAME STREQUAL "upcomingmajor"
    AND NOT CDASH_BRANCH_NAME STREQUAL "upcomingminor10"
    AND NOT CDASH_BRANCH_NAME STREQUAL "upcomingminor"
    AND NOT CDASH_BRANCH_NAME STREQUAL "upcomingpatch10"
    AND NOT CDASH_BRANCH_NAME STREQUAL "stablemajor"
    AND NOT CDASH_BRANCH_NAME STREQUAL "stableminor10"
    AND NOT CDASH_BRANCH_NAME STREQUAL "stablepatch10"
    AND NOT CDASH_BRANCH_NAME STREQUAL "releaseupcomingmajor"
    AND NOT CDASH_BRANCH_NAME STREQUAL "releaseupcomingminor10"
    AND NOT CDASH_BRANCH_NAME STREQUAL "releaseupcomingpatch"
    AND NOT CDASH_BRANCH_NAME STREQUAL "releasestablemajor"
    AND NOT CDASH_BRANCH_NAME STREQUAL "releasestableminor10"
    AND NOT CDASH_BRANCH_NAME STREQUAL "releasestablepatch"
    AND NOT CDASH_BRANCH_NAME STREQUAL "stablemajor2"
    AND NOT CDASH_BRANCH_NAME STREQUAL "upcomingmajor2"
    AND NOT CDASH_BRANCH_NAME STREQUAL "stablemajor3"
    AND NOT CDASH_BRANCH_NAME STREQUAL "upcomingmajor3"
  )
    set(CDASH_BRANCH_NAME "custombranches")
  endif()
endif()




