# - Try to find the sed command
IF( NOT SED_EXE )
  set(SED_PATHS /usr/local /usr /)

  # On Windows, sed is installed with Git, usually in C:/Path/To/Git/usr/bin/sed.exe
  # Here, we retrieve Git install dir and build sed path from git executable path
  if (WIN32)
    find_package(Git)
    if(GIT_FOUND)
      # When launching cmake from Windows cmd, the git executable path will be something like C:/Path/To/Git/bin/git.exe or C:/Path/To/Git/cmd/git.exe
      # But when launching cmake from Git Bash, the path might be C:/Path/To/Git/mingw64/bin/git.exe
      # So we need to add 2 paths for finding sed: ${GIT_EXE}/../../usr/bin and ${GIT_EXE}/../../../usr/bin
      get_filename_component(GIT_EXE_P0 ${GIT_EXE} DIRECTORY)    # Parent dir of git executable
      get_filename_component(GIT_EXE_P1 ${GIT_EXE_P0} DIRECTORY) # Parent dir of parent dir
      get_filename_component(GIT_EXE_P2 ${GIT_EXE_P1} DIRECTORY) # ...
      list(INSERT SED_PATHS 0 ${GIT_EXE_P1}/usr ${GIT_EXE_P2}/usr)
    endif()
  endif()

  FIND_PROGRAM( SED_EXE
    NAMES sed sed.exe
    PATHS ${SED_PATHS}
    PATH_SUFFIXES bin
    NO_CMAKE_PATH NO_CMAKE_ENVIRONMENT_PATH NO_CMAKE_SYSTEM_PATH NO_SYSTEM_ENVIRONMENT_PATH
    DOC "sed executable" )
ENDIF()

IF( NOT SED_EXE )
  SET( SET_FOUND FALSE )
  SET( SED_EXE "[SED_EXE-NOTFOUND]" CACHE FILEPATH "sed command" )
  MESSAGE( FATAL_ERROR "Unable to find the sed command. Please provide SED_EXE variable." )
ENDIF()

SET( SED_FOUND TRUE )
GET_FILENAME_COMPONENT( _sedPath ${SED_EXE}  DIRECTORY )
FILE( TO_NATIVE_PATH ${_sedPath} SED_PATH )
