# GPU detection: GPU name and driver version
#
# Possible GPU string to test return are : INTEL, ATI NVIDIA

####################################################################
# WARNING : DO NOT USE ANY VARIABLE NAME IN COMMENT OF THIS FILE   #
# CONFIGURE_FILE REPLACE THEM WITH THEIR CMAKE VALUE EVENT IF THEY #
# ARE COMMENTED. JUST USE THEM IN TEST BUT NOT IN COMMENT          #
####################################################################

set(GPU_NAME "")
set(GPU_DRIVER "")

if(MSVC)
  #WINDOWS
  execute_process( COMMAND wmic PATH Win32_videocontroller GET Description
                 WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
                 RESULT_VARIABLE GPU_NAME_RES
                 OUTPUT_VARIABLE GPU_NAME
                 OUTPUT_STRIP_TRAILING_WHITESPACE
                 )

  if ( GPU_NAME STREQUAL "")
    MESSAGE (STATUS "No Gpu Detected")
    set (GPU_NAME "NO_GPU")
  else()
    STRING(REGEX REPLACE "Description[ ]*" "" GPU_NAME ${GPU_NAME})
    STRING(REGEX REPLACE "\r\n" "" GPU_NAME ${GPU_NAME})
  endif()

  execute_process( COMMAND wmic PATH Win32_videocontroller GET DriverVersion
                 WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
                 RESULT_VARIABLE GPU_DRIVER_RES
                 OUTPUT_VARIABLE GPU_DRIVER
                 OUTPUT_STRIP_TRAILING_WHITESPACE
                 )

  if ( GPU_DRIVER STREQUAL "")
    MESSAGE (STATUS "No Gpu driver Detected")
    set (GPU_DRIVER "NO_GPU_DRIVER")
  else()
    STRING(REGEX REPLACE "DriverVersion[ ]*" "" GPU_DRIVER ${GPU_DRIVER})
    STRING(REGEX REPLACE "\r\n" "" GPU_DRIVER ${GPU_DRIVER})
  endif()

else()
  #UNIX
  execute_process( COMMAND glxinfo
                 WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
                 OUTPUT_STRIP_TRAILING_WHITESPACE
                 OUTPUT_QUIET
                 ERROR_VARIABLE GPU_DETECTION
                 )

  if ( GPU_DETECTION MATCHES "Error: unable to open display" )
    MESSAGE (STATUS "No Gpu Detected")
    set (GPU_NAME "NO_GPU")
    MESSAGE (STATUS "No Gpu driver Detected")
    set (GPU_DRIVER "NO_GPU_DRIVER")
  else()
    execute_process( COMMAND glxinfo
            COMMAND grep "OpenGL renderer string"
            WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
            RESULT_VARIABLE GPU_NAME_RES
            OUTPUT_VARIABLE GPU_NAME
            OUTPUT_STRIP_TRAILING_WHITESPACE
            )
    string(REGEX REPLACE "OpenGL renderer string: " "" GPU_NAME "${GPU_NAME}")

    execute_process( COMMAND glxinfo
            COMMAND grep "OpenGL core profile version string"
            WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
            RESULT_VARIABLE GPU_DRIVER_RES
            OUTPUT_VARIABLE GPU_DRIVER
            OUTPUT_STRIP_TRAILING_WHITESPACE
            )
    string(REGEX REPLACE "OpenGL core profile version string: " "" GPU_DRIVER "${GPU_DRIVER}")
    if( GPU_DRIVER MATCHES "Mesa" )
      string(REGEX REPLACE " \\(git.*" "" GPU_DRIVER "${GPU_DRIVER}")
    endif()

    if ( GPU_DRIVER STREQUAL "")
      execute_process( COMMAND glxinfo
            COMMAND grep "OpenGL version string"
            WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
            RESULT_VARIABLE GPU_DRIVER_RES
            OUTPUT_VARIABLE GPU_DRIVER
            OUTPUT_STRIP_TRAILING_WHITESPACE
            )
      string(REGEX REPLACE "OpenGL version string: " "" GPU_DRIVER "${GPU_DRIVER}")
    endif()
  endif()
endif()

message(STATUS "GPU name: ${GPU_NAME}")
message(STATUS "GPU driver version: ${GPU_DRIVER}")
