set(result -1)
set(error "git")
if(EXISTS "${GIT_EXE}")
  execute_process(COMMAND ${GIT_EXE} log "--pretty=format:%H" -1
                  OUTPUT_VARIABLE OIV_INTERNAL_BUILD_KEY
                  WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
                  ERROR_VARIABLE error
                  RESULT_VARIABLE result)
endif()

if(result)
  message(STATUS "Warning while getting git sha1: ${error} result is ${result}")
  unset(error)
  unset(result)
  set(OIV_INTERNAL_BUILD_KEY "Custom Build")
endif()
