##############################################################
## Common macro used by TOOLKIT/UNITTEST/DEMOS packages BUILD
# ADD_OIV_EXECUTABLE (TARGET_NAME ARGN)
#    - Add executable TARGET_NAME and add a new test ADD_OIV_RUNTEST_EXE with name 
#      RUN_TARGET_NAME
# ADD_OIV_EXECUTABLE_NOTEST (TARGET_NAME ARGN)
#    - Add executable without test.
# ADD_OIV_RUNTEST_EXE (TARGET_NAME EXE_NAME [TIMEOUT=20]):
#    - Add a test with name =  RUN_+<TARGET_NAME>
#    - Set OIV environment variable = OIV_OPENGL_DEBUG=1;OIV_HANDLE_CRASHES=1;OIV_DISABLE_MAINLOOP=1
#      (Note that OIV_DISABLE_MAINLOOP is necessary to run demo otherwise it will be timeout)
#	 - Optional timeout value can be set, its default value is 20 seconds
#
# ADD_OIV_RUNTEST_EXE_CORE (TARGET_NAME EXE_NAME OIV_ENV [TIMEOUT=20])
#    - Add a test if OIV_IGNORE_RUNTEST = false
#	 - Optional timeout value can be set, its default value is 20 seconds
##############################################################

# associate a sub-solution to the project
MACRO(SET_SOLUTION_FOLDER TARGET_NAME)
  IF(DEFINED DEFAULT_PROJECT_FOLDER)
    SET_PROPERTY(TARGET ${TARGET_NAME} PROPERTY FOLDER ${DEFAULT_PROJECT_FOLDER})
  ELSEIF (DEFINED OIV_MODULE)
    SET_PROPERTY(TARGET ${TARGET_NAME} PROPERTY FOLDER ${OIV_MODULE})
  endif()
ENDMACRO(SET_SOLUTION_FOLDER)

MACRO(IGNORE_OIV_RUNTEST)
SET(OIV_IGNORE_RUNTEST TRUE)
ENDMACRO(IGNORE_OIV_RUNTEST)

MACRO(IGNORE_OIV_RUNTEST_OFF)
SET(OIV_IGNORE_RUNTEST FALSE)
ENDMACRO(IGNORE_OIV_RUNTEST_OFF)

MACRO(ADD_OIV_RUNTEST_PARAMETER PARAM)
  SET(OIV_RUNTEST_PARAMETERS ${OIV_RUNTEST_PARAMETERS} ${PARAM})
ENDMACRO(ADD_OIV_RUNTEST_PARAMETER)

# Add a test that takes a single snapshot of a given IV file
# using a SoOffscreenRenderArea
# Can only be used in UnitTests
function(add_oiv_print_iv_test TEST_NAME IV_FILE)
  unset(OIV_MODULE)
  SET_OIV_CMAKE_OUTPUT_DIRECTORIES()
  string(REPLACE ${ROOT_DIR} "" CURRENT_OUTPUT_DIR ${OIV_TESTS_OUTPUT_PATH} ${CMAKE_CURRENT_SOURCE_DIR})
  add_unittest_test(${TEST_NAME} ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/IvFilePrinter ${IV_FILE} -o ${CURRENT_OUTPUT_DIR}/${TEST_NAME}.png)
endfunction()

# Add graphical test that automatically grab frame 1 and 20.
# usage:
# add_oiv_graphical_test(test_name [test_executable] [executable_arguments])
MACRO(add_oiv_graphical_test TEST_NAME)
  if(OIV_ENABLE_TESTS)

    set(TEST_EXECUTABLE ${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/${TEST_NAME})

    # Cannot use ARGN directly with list() command,
    # so copy it to a variable first.
    set (extra_macro_args ${ARGN})

    # if we have extra args, the 1st one is the name of executable.
    # extract it from list
    list(LENGTH extra_macro_args num_extra_args)
    if (${num_extra_args} GREATER 0)
      list(GET extra_macro_args 0 TEST_EXECUTABLE)
      # Remove text executable from arg list to propagate to add_unittest_test macro
      list(REMOVE_AT extra_macro_args 0)
    endif ()
    file(TO_CMAKE_PATH ${TEST_EXECUTABLE} TEST_EXECUTABLE)

    #filepath will be the relative path of the test source directory (relative to OivSuite/UnitTests)
    #(eg: /path/OivSuite/UnitTests/VolumeViz/picking = > VolumeViz/picking
    set(basedir ${CMAKE_SOURCE_DIR})
    #basedir change if we are runiing from OivSuite or from OivSuite/UnitTests
    if(OIV_DEV_BUILD)
      set(basedir "${CMAKE_SOURCE_DIR}/UnitTests")
    endif()
    string(REPLACE ${basedir} "" filepath ${CMAKE_CURRENT_SOURCE_DIR})
    file(TO_CMAKE_PATH ${filepath} filepath)
    set(graphical_output_base "${OIV_TESTS_OUTPUT_PATH}/${filepath}/${TEST_NAME}")
    set(OIV_ENV "OIV_TESTS_GRAPHICAL_OUTPUT_BASE=${graphical_output_base} OIV_TESTS_GRAPHICAL_OUTPUT_GRABBED_FRAMES=\"1,20\"")
    add_unittest_test(${TEST_NAME} ${TEST_EXECUTABLE} ENVIRONMENT OIV_ENV ${extra_macro_args})
  endif()
ENDMACRO()

MACRO(ADD_OIV_RUNTEST TARGET_NAME)
  IF (OIV_ENABLE_RUNTESTS)
    add_oiv_runtest_exe(${TARGET_NAME} ${TARGET_NAME})
  endif()
ENDMACRO(ADD_OIV_RUNTEST)

MACRO(ADD_OIV_RUNTEST_EXE TARGET_NAME EXE_NAME)
  SET(OIV_ENV "OIV_HANDLE_CRASHES=1;OIV_DISABLE_MAINLOOP=1;OIV_GENERIC_READER_ENABLE_VVIZ=0")
  IF (MSVC)
    #Add OIV_OPENGL_DEBUG only on Win, because linux will report to much useless information
    SET(OIV_ENV "OIV_OPENGL_DEBUG=1" ${OIV_ENV})
  ENDIF()

  IF( NOT "${ARGN}" STREQUAL "" )
    SET(UTEST_TIMEOUT "${ARGV2}")
  ENDIF()

  ADD_OIV_RUNTEST_EXE_CORE(${TARGET_NAME} ${EXE_NAME} "${OIV_ENV}" ${UTEST_TIMEOUT})
ENDMACRO(ADD_OIV_RUNTEST_EXE)

MACRO(ADD_OIV_RUNTEST_EXE_CORE OIV_TEST_NAME EXE_NAME OIV_ENV_INPUT)
  SET(OIV_TEST_RUNNAME "RUN_${OIV_TEST_NAME}")
  IF (NOT OIV_IGNORE_RUNTEST)
    if (${EXE_NAME}_OIV_IS_UNITTEST)
      set(OIV_TEST_RUNNAME "${OIV_TEST_RUNNAME}_CpuUnitTest")
    endif()
    FIX_EXECUTABLE_PATH_FUNC("${CMAKE_RUNTIME_OUTPUT_DIRECTORY}/${EXE_NAME}" "Release" OIV_TEST_PATH)

    ADD_TEST(${OIV_TEST_RUNNAME} ${OIV_TEST_PATH} ${OIV_RUNTEST_PARAMETERS})
    set(extra_macro_args ${ARGN})
    list(LENGTH extra_macro_args num_extra_args)
    if( ${num_extra_args} GREATER 0 )
     set(UTEST_TIMEOUT "${ARGV3}")
    else()
     set(UTEST_TIMEOUT 20)
    endif()

    # Ensure timeout is valid
    if(NOT ${UTEST_TIMEOUT} GREATER 0)
      message(WARNING "${UTEST_TIMEOUT} is not a valid timeout value for test ${OIV_TEST_NAME}")
    endif()

    set_tests_properties(${OIV_TEST_RUNNAME} PROPERTIES TIMEOUT ${UTEST_TIMEOUT})
    set_tests_properties(${OIV_TEST_RUNNAME} PROPERTIES ENVIRONMENT "${OIV_ENV_INPUT}")

    if(APPLE)
      #Set environment for tests so the custom nodes are loaded
      set(CUSTOM_NODES_ENV "$ENV{LD_LIBRARY_PATH}:${CMAKE_RUNTIME_OUTPUT_DIRECTORY}")
      set_property(TEST ${OIV_TEST_RUNNAME} APPEND PROPERTY ENVIRONMENT "LD_LIBRARY_PATH=${CUSTOM_NODES_ENV}")
      set_property(TEST ${OIV_TEST_RUNNAME} APPEND PROPERTY ENVIRONMENT "DYLD_LIBRARY_PATH=${CUSTOM_NODES_ENV}")
    endif()

  endif()

  # We reset the ignore flag here
  SET(OIV_RUNTEST_PARAMETERS "")
  IGNORE_OIV_RUNTEST_OFF()
ENDMACRO(ADD_OIV_RUNTEST_EXE_CORE)

# Alias to set CMAKE_LIBRARY_OUTPUT_DIRECTORY* and CMAKE_RUNTIME_OUTPUT_DIRECTORY*
MACRO(SET_OIV_CMAKE_OUTPUT_DIRECTORIES)

  IF(NOT OIV_TOOLKIT_BUILD)
    IF(${OIV_OUTPUT_DIR} MATCHES "arch-")
      SET(CMAKE_LIBRARY_OUTPUT_DIRECTORY ${OIV_OUTPUT_DIR}/${OIV_MODULE})
      SET(CMAKE_RUNTIME_OUTPUT_DIRECTORY ${OIV_OUTPUT_DIR}/${OIV_MODULE})
      SET(CMAKE_ARCHIVE_OUTPUT_DIRECTORY ${OIV_OUTPUT_DIR}/${OIV_MODULE})
      SET(CMAKE_LIBRARY_OUTPUT_DIRECTORY_RELEASE ${OIV_OUTPUT_DIR}/${OIV_MODULE})
      SET(CMAKE_RUNTIME_OUTPUT_DIRECTORY_RELEASE ${OIV_OUTPUT_DIR}/${OIV_MODULE})
      SET(CMAKE_ARCHIVE_OUTPUT_DIRECTORY_RELEASE ${OIV_OUTPUT_DIR}/${OIV_MODULE})
      SET(CMAKE_LIBRARY_OUTPUT_DIRECTORY_DEBUG ${OIV_OUTPUT_DIR}/${OIV_MODULE})
      SET(CMAKE_RUNTIME_OUTPUT_DIRECTORY_DEBUG ${OIV_OUTPUT_DIR}/${OIV_MODULE})
      SET(CMAKE_ARCHIVE_OUTPUT_DIRECTORY_DEBUG ${OIV_OUTPUT_DIR}/${OIV_MODULE})
      SET(CMAKE_LIBRARY_OUTPUT_DIRECTORY_MINSIZEREL ${OIV_OUTPUT_DIR}/${OIV_MODULE})
      SET(CMAKE_RUNTIME_OUTPUT_DIRECTORY_MINSIZEREL ${OIV_OUTPUT_DIR}/${OIV_MODULE})
      SET(CMAKE_ARCHIVE_OUTPUT_DIRECTORY_MINSIZEREL ${OIV_OUTPUT_DIR}/${OIV_MODULE})
    else()
      SET(CMAKE_LIBRARY_OUTPUT_DIRECTORY ${CMAKE_CURRENT_BINARY_DIR})
      SET(CMAKE_RUNTIME_OUTPUT_DIRECTORY ${CMAKE_CURRENT_BINARY_DIR})
      SET(CMAKE_ARCHIVE_OUTPUT_DIRECTORY ${CMAKE_CURRENT_BINARY_DIR})
    endif()
    IF(OIV_ENABLE_EBUGS)
      set(CMAKE_LIBRARY_OUTPUT_DIRECTORY ${CMAKE_BINARY_DIR}/${EBUGS_OUTPUT_DIR})
      set(CMAKE_RUNTIME_OUTPUT_DIRECTORY ${CMAKE_BINARY_DIR}/${EBUGS_OUTPUT_DIR})
      set(CMAKE_ARCHIVE_OUTPUT_DIRECTORY ${CMAKE_BINARY_DIR}/${EBUGS_OUTPUT_DIR})
      set(CMAKE_LIBRARY_OUTPUT_DIRECTORY_RELEASE ${CMAKE_BINARY_DIR}/${EBUGS_OUTPUT_DIR})
      set(CMAKE_RUNTIME_OUTPUT_DIRECTORY_RELEASE ${CMAKE_BINARY_DIR}/${EBUGS_OUTPUT_DIR})
      set(CMAKE_ARCHIVE_OUTPUT_DIRECTORY_RELEASE ${CMAKE_BINARY_DIR}/${EBUGS_OUTPUT_DIR})
      set(CMAKE_LIBRARY_OUTPUT_DIRECTORY_DEBUG ${CMAKE_BINARY_DIR}/${EBUGS_OUTPUT_DIR})
      set(CMAKE_RUNTIME_OUTPUT_DIRECTORY_DEBUG ${CMAKE_BINARY_DIR}/${EBUGS_OUTPUT_DIR})
      set(CMAKE_ARCHIVE_OUTPUT_DIRECTORY_DEBUG ${CMAKE_BINARY_DIR}/${EBUGS_OUTPUT_DIR})
      set(CMAKE_LIBRARY_OUTPUT_DIRECTORY_MINSIZEREL ${CMAKE_BINARY_DIR}/${EBUGS_OUTPUT_DIR})
      set(CMAKE_RUNTIME_OUTPUT_DIRECTORY_MINSIZEREL ${CMAKE_BINARY_DIR}/${EBUGS_OUTPUT_DIR})
      set(CMAKE_ARCHIVE_OUTPUT_DIRECTORY_MINSIZEREL ${CMAKE_BINARY_DIR}/${EBUGS_OUTPUT_DIR})
    endif()
  endif()

ENDMACRO(SET_OIV_CMAKE_OUTPUT_DIRECTORIES)

# Alias to add_executable in a specific directory
MACRO(ADD_OIV_EXECUTABLE TARGET_NAME)
  SET_OIV_CMAKE_OUTPUT_DIRECTORIES()
  ADD_EXECUTABLE(${TARGET_NAME} ${ARGN})
  SET_SOLUTION_FOLDER(${TARGET_NAME})
  SET_PROPERTY(GLOBAL APPEND PROPERTY OIV_EXECUTABLE_TARGET_LIST "${TARGET_NAME}")
  # For Visual Studio 2012 or 2013 or 2015 or 2017, overload subsytem flag of linker
  IF(MSVC)
    IF(MSVC_VERSION LESS_EQUAL 1950)
      set(SUBSYSTEM_FLAG "${CMAKE_CREATE_CONSOLE_EXE}")

      # Check if the executable is a WIN32 application
      set(extra_macro_args ${ARGN})
      list(LENGTH extra_macro_args num_extra_args)
      IF( ${num_extra_args} GREATER 0 )
        list(GET extra_macro_args 0 first_arg)
        IF( ${first_arg} STREQUAL WIN32 )
          set(SUBSYSTEM_FLAG "${CMAKE_CREATE_WIN32_EXE}") # Not a "console" application
        ENDIF()
      ENDIF()

      # overload the linker flags
      set_target_properties(${TARGET_NAME} PROPERTIES LINK_FLAGS "${SUBSYSTEM_FLAG}")
    ELSEIF(MSVC_VERSION GREATER 1950)
      # Protection for newer version in order to check the compatibility of this add
      message(FATAL_ERROR "The subsystem linker flags is not supported for ${CMAKE_GENERATOR} generator!")
    ENDIF()
  endif()

  ADD_OIV_RUNTEST( ${TARGET_NAME} )
ENDMACRO(ADD_OIV_EXECUTABLE)

# Alias to add_executable in a specific directory without adding the RUN_ test to the executable
MACRO(ADD_OIV_EXECUTABLE_NOTEST TARGET_NAME_NO_TEST)
  SET(OIV_IGNORE_RUNTEST TRUE)
  ADD_OIV_EXECUTABLE(${TARGET_NAME_NO_TEST} ${ARGN})
  SET(OIV_IGNORE_RUNTEST FALSE)
ENDMACRO(ADD_OIV_EXECUTABLE_NOTEST)

# Alias to add_executable in a specific directory without adding the RUN_ test to the executable
MACRO(ADD_OIV_QT_EXECUTABLE TARGET_NAME)
  ADD_OIV_EXECUTABLE(${TARGET_NAME} ${ARGN})
  target_compile_definitions(${TARGET_NAME} PRIVATE SOQT)
  if (${QT_VERSION_MAJOR} EQUAL 6)
    qt_allow_non_utf8_sources(${TARGET_NAME})
    qt_disable_unicode_defines(${TARGET_NAME})
  endif()
ENDMACRO(ADD_OIV_QT_EXECUTABLE)


# Alias to add_executable in a specific directory
MACRO(ADD_OIV_QT_EXECUTABLE_NOTEST TARGET_NAME)
  SET(OIV_IGNORE_RUNTEST TRUE)
  ADD_OIV_QT_EXECUTABLE(${TARGET_NAME} ${ARGN})
  SET(OIV_IGNORE_RUNTEST FALSE)
ENDMACRO()

# Alias to add_library in a specific directory
MACRO(ADD_OIV_LIBRARY TARGET_NAME)
  SET_OIV_CMAKE_OUTPUT_DIRECTORIES()
  ADD_LIBRARY(${TARGET_NAME} ${ARGN})
  SET_SOLUTION_FOLDER(${TARGET_NAME})
  SET_PROPERTY(GLOBAL APPEND PROPERTY OIV_LIBRARY_TARGET_LIST "${TARGET_NAME}")

  IF(MSVC)
    if(NOT OIV_INCREMENTAL_LINK)
      set_target_properties(${TARGET_NAME} PROPERTIES LINK_FLAGS "/INCREMENTAL:NO")
    endif()
  else()
    IF(OIV_BUILD_STATIC)
      MAKE_STATIC(static_cmd ${ARGN})
      ADD_LIBRARY(${TARGET_NAME}Static ${static_cmd})
      SET_TARGET_PROPERTIES( ${TARGET_NAME} ${TARGET_NAME}Static PROPERTIES CLEAN_DIRECT_OUTPUT 1 )
      SET_TARGET_PROPERTIES( ${TARGET_NAME}Static PROPERTIES OUTPUT_NAME ${TARGET_NAME} )
    endif()
  endif()

ENDMACRO(ADD_OIV_LIBRARY)

# create hierarchical source groups
macro(create_vcproj_hierarchy prefix project_dir)
  if(MSVC_IDE)
    foreach( _source ${ARGN} )
      string(REGEX REPLACE "//" "/" _source "${_source}" )
      # get path component from filename
      get_filename_component(_path "${_source}" PATH)
      # remove prefix from filename
      string(REPLACE "${project_dir}" "" _relative_path "${_path}" )
      # remove any leading slashes
      string(REGEX REPLACE "^[\\\\/]" "" _relative_path "${_relative_path}" )
      source_group("${prefix}/${_relative_path}" FILES ${_source} )
    endforeach()
  endif()
endmacro(create_vcproj_hierarchy)

FUNCTION(FIX_EXECUTABLE_PATH_FUNC EXECUTABLE BUILD_TYPE EXECUTABLE_FIXED)
  #CMake variable MSVC_VERSION == 1500 <=> VC9
  IF( MSVC AND MSVC_VERSION GREATER 1500 )
    STRING(REGEX REPLACE "-\\\$\\\([cC]onfiguration\\\)" "-${BUILD_TYPE}" EXECUTABLE ${EXECUTABLE})
  ELSE()
    STRING(REGEX REPLACE "-\\\$\\\(OutDir\\\)" "-${BUILD_TYPE}" EXECUTABLE ${EXECUTABLE} )
  ENDIF()
  SET(${EXECUTABLE_FIXED} ${EXECUTABLE} PARENT_SCOPE)
ENDFUNCTION()

FUNCTION(FIX_EXECUTABLE_PATH_FUNC_ARRAY EXECUTABLEARRAY BUILD_TYPE EXECUTABLE_FIXED)
  SET(EXECUTABLE_FIXED_ARRAY)
  FOREACH( _source ${ARGN} )
    FIX_EXECUTABLE_PATH_FUNC( ${_source} ${BUILD_TYPE} EXECUTABLE_FIXED_TMP )
    SET(EXECUTABLE_FIXED_ARRAY "${EXECUTABLE_FIXED_ARRAY};${EXECUTABLE_FIXED_TMP}" )
  endforeach()
  SET(${EXECUTABLE_FIXED} ${EXECUTABLE_FIXED_ARRAY} PARENT_SCOPE)
ENDFUNCTION()

# Alias to add_test in a correct directory
# This works in release mode only
MACRO(ADD_OIV_TEST TEST_NAME TARGET_NAME)
  FIX_EXECUTABLE_PATH_FUNC(${TARGET_NAME} "Release" TARGET_NAME2)
  ADD_TEST(${TEST_NAME} ${TARGET_NAME2} ${ARGN})
ENDMACRO(ADD_OIV_TEST)

# prepend the given suffix only if path is relative
macro(prefix_if_relative path prefix)
  if(NOT IS_ABSOLUTE ${${path}})
    set(${path} "${prefix}/${${path}}")
  endif()
endmacro(prefix_if_relative)

macro(list_prefix_if_relative list prefix)
  set(_plist)
  foreach(elt ${${list}})
    prefix_if_relative(elt ${prefix})
    set(_plist ${_plist} ${elt})
  endforeach()
  set(${list} ${_plist})
endmacro(list_prefix_if_relative)

# import a given subdirectory
# append list of sources to ${sources}
macro(import_subdirectory directory)# sources headers)
  add_subdirectory(${directory})
  get_directory_property(_definitions DIRECTORY ${directory} DEFINITION EXTRA_DEFINES)
  if(_definitions)
    add_definitions(${_definitions})
  endif()
  get_directory_property(_include_directories DIRECTORY ${directory} INCLUDE_DIRECTORIES)
  if(_include_directories)
    get_directory_property(_this_include_directories DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR} INCLUDE_DIRECTORIES)
    list(REMOVE_ITEM _include_directories ${_this_include_directories})
    if(_include_directories)
      include_directories(${_include_directories})
    endif()
  endif()

  if(NOT IS_ABSOLUTE ${directory})
    get_filename_component(_directory "${directory}" ABSOLUTE)
    file(RELATIVE_PATH _directory ${CMAKE_CURRENT_SOURCE_DIR} ${_directory})
  endif()

  foreach(arg ${ARGN})
    get_directory_property(_arg DIRECTORY ${directory} DEFINITION ${arg})
    if(NOT _arg)
      get_filename_component(_directory "${directory}" ABSOLUTE)
      message(FATAL_ERROR "Try to get unset variable ${arg} from ${_directory}")
    endif()
    list_prefix_if_relative(_arg "${_directory}/")
    set(${arg} ${_arg})
  endforeach()
endmacro(import_subdirectory)

MACRO (MAKE_STATIC static_arg)
  SET (${static_arg})
  FOREACH(_currentArg ${ARGN})
    IF ("${_currentArg}" STREQUAL "SHARED")
      LIST(APPEND ${static_arg} "STATIC")
    else()
      LIST(APPEND ${static_arg} "${_currentArg}")
    endif()
  endforeach()
ENDMACRO (MAKE_STATIC)

# Checks if a list contains an element
# example:
#   set(MYLIST hello world foo bar)
#   list_contains(contains foo ${MYLIST})
#   if (contains)
#     MESSAGE("MYLIST contains foo")
#   endif()
macro(list_contains var value)
  set(${var})
  foreach (value2 ${ARGN})
    if(${value} STREQUAL ${value2})
      set(${var} TRUE)
    endif()
  endforeach()
endmacro(list_contains)


# Filter and add a list of dependencies
# example:
#   set(MYDEPS v1 v2 v3 v4)
#   set(EXCLUDEDDEPS v2 v3)
#   add_filtered_dependencies(MYTARGET MYDEPS EXCLUDEDDEPS)
#   It is equivalent to: add_dependencies(MYTARGET v1 v4)
macro(add_filtered_dependencies target dependlist exceptionlist)
  foreach(dep ${${dependlist}})
    if (NOT ${exceptionlist})
      add_dependencies(${target} ${dep})
    else()
      list_contains(contains ${dep} ${${exceptionlist}})
      if(NOT contains)
        add_dependencies(${target} ${dep})
      endif()
    endif()
  endforeach()
endmacro(add_filtered_dependencies)


# Convert given files to c string files
MACRO (UTILS_TXTFILE2MAP outfiles basepath)
  FOREACH (it ${ARGN})
    GET_FILENAME_COMPONENT(infile ${it} ABSOLUTE)
    STRING(REPLACE "${basepath}" "" outfile "${it}")

    set(shadername "${outfile}")
    SET(outfile ${CMAKE_CURRENT_BINARY_DIR}/embedded-shaders/${outfile}.inc)
    FILE(MAKE_DIRECTORY ${CMAKE_CURRENT_BINARY_DIR}/embedded-shaders)
    
    ADD_CUSTOM_COMMAND(
      OUTPUT ${outfile}
      COMMAND "${Python_EXECUTABLE}"
      ARGS
      "${OIV_COMMON_CMAKE_DIR}/parseShaderFile.py"
      "${shadername}"
      "${infile}"
      "${outfile}"
      MAIN_DEPENDENCY ${infile}
      COMMENT "Embedding text file ${infile} ..."
    )
    SET(${outfiles} ${${outfiles}} ${outfile})
  endforeach()
ENDMACRO (UTILS_TXTFILE2MAP)

# this macro adds a command to copy a target to the Demos dir in OIVHOME/OIVARCH
# to satisfy some art files that use OIV_USER_LIBS to explicitly load a library from this folder.
# This allows these tests to pass even in OIV_DEV_BUILD.
# Since this is only relevant in OIV_DEV_BUILD it only does anything in OIV_DEV_BUILD
macro(copy_to_demo_dir targetName)
  if(OIV_DEV_BUILD)
    add_custom_command(TARGET ${targetName}
                       POST_BUILD
                       COMMAND ${CMAKE_COMMAND} -E copy $<TARGET_FILE:${targetName}> "${OIVHOME}/${OIVARCH}/Demos/${OIV_MODULE}/$<TARGET_FILE_NAME:${targetName}>")
  endif()
endmacro()

# Enable or not the build of module examples, a "condition" parameter is optional.
macro(enable_examples moduleName)
  set(extra_macro_args ${ARGN})

  # Did we get any optional args?
  list(LENGTH extra_macro_args num_extra_args)
  if (${num_extra_args} GREATER 0)
    list(GET extra_macro_args 0 optional_condition)
    if (${optional_condition} AND ${OIV_ENABLE_${moduleName}_EXAMPLES})
      set(OIV_ENABLE_${moduleName}_EXAMPLES TRUE)
    else()
      set(OIV_ENABLE_${moduleName}_EXAMPLES FALSE)
    endif()
  else()
    set(OIV_ENABLE_${moduleName}_EXAMPLES FALSE)
  endif()
endmacro()
