# available architectures
# Linux/Windows/OSX-GNU/MSVC[9/10/11/12]-i386/x86_64

#Detect linux ubuntu ditrib (LINUX_PLATFORM is "Ubuntu" or "CentOS"
find_program(LSB_RELEASE_EXEC lsb_release)
execute_process(COMMAND ${LSB_RELEASE_EXEC} -isr
    OUTPUT_VARIABLE LINUX_PLATFORM
    OUTPUT_STRIP_TRAILING_WHITESPACE
)

# Detect Windows version
if(WIN32)
  if(${CMAKE_SYSTEM_VERSION} VERSION_GREATER_EQUAL "10.0.22000")
    set(WINDOWS_VERSION 11)
  elseif(${CMAKE_SYSTEM_VERSION} VERSION_GREATER_EQUAL "10.0")
    set(WINDOWS_VERSION 10)
  elseif(${CMAKE_SYSTEM_VERSION} VERSION_GREATER_EQUAL "6.2")
    set(WINDOWS_VERSION 8)
  else()
    set(WINDOWS_VERSION 7)
  endif()
  message(STATUS "Detected Windows " ${WINDOWS_VERSION})
endif()

if(MSVC)
  set(OIV_CXX_COMPILER_ID "msvc")
  message(STATUS "MSVC version ${MSVC_VERSION}")

  if(MSVC_VERSION EQUAL 1700)
    set(OIV_CXX_COMPILER_VERSION "11")
  endif()
  if(MSVC_VERSION EQUAL 1800)
    set(OIV_CXX_COMPILER_VERSION "12")
  endif()
  if(MSVC_VERSION EQUAL 1900)
    set(OIV_CXX_COMPILER_VERSION "14")
  endif()
  if(MSVC_VERSION GREATER_EQUAL 1910 AND MSVC_VERSION LESS_EQUAL 1919)
    set(OIV_CXX_COMPILER_VERSION "15")
  endif()
  if(MSVC_VERSION GREATER_EQUAL 1930 AND MSVC_VERSION LESS_EQUAL 1950)
    set(OIV_CXX_COMPILER_VERSION "17")
  endif()

  set(CMAKE_SYSTEM_PROCESSOR x86_64)

  # For Visual Studio 2012 or 2013 or 2015 or 2017, need to add some specific linker flags
  IF(MSVC_VERSION LESS_EQUAL 1950)
    # Select the arch.
    IF(CMAKE_CL_64)
      set(VISUAL_ARCH "5.02")
    else()
      set(VISUAL_ARCH "5.01")
    endif()
    # Complete the subsytem linker flags
    set(CMAKE_CREATE_CONSOLE_EXE "/SUBSYSTEM:CONSOLE,${VISUAL_ARCH}")
    set(CMAKE_CREATE_WIN32_EXE "/SUBSYSTEM:WINDOWS,${VISUAL_ARCH}")
    set(CMAKE_MODULE_LINKER_FLAGS "/SUBSYSTEM:CONSOLE,${VISUAL_ARCH} ${CMAKE_MODULE_LINKER_FLAGS}")
    set(CMAKE_SHARED_LINKER_FLAGS "/SUBSYSTEM:CONSOLE,${VISUAL_ARCH} ${CMAKE_SHARED_LINKER_FLAGS}")
    message(STATUS "The ${CMAKE_GENERATOR} generator is set with ${CMAKE_CREATE_CONSOLE_EXE}")
  ELSEIF(MSVC_VERSION GREATER 1950)
    # Protection for newer version in order to check the compatibility of this add
    message(FATAL_ERROR "The ${CMAKE_GENERATOR} generator is not supported !")
  ENDIF()

  # add D as sufix for all debug dlls
  set(CMAKE_DEBUG_POSTFIX "D")
endif()

if(APPLE)
  set(CMAKE_CXX_PLATFORM_ID  "OSX")
endif()

if(CMAKE_CXX_COMPILER_ID STREQUAL "GNU") # GCC
  set(OIV_CXX_COMPILER_ID "gcc")
  string(SUBSTRING ${CMAKE_CXX_COMPILER_VERSION} 0 1 major_version)
  string(SUBSTRING ${CMAKE_CXX_COMPILER_VERSION} 2 1 release_version)
  if (CMAKE_CXX_COMPILER_VERSION VERSION_GREATER 5.0)
    set(release_version "") # From GCC 5, only major version is significant.
  endif()
  set(OIV_CXX_COMPILER_VERSION "${major_version}${release_version}" CACHE STRING "GCC version used for prepacked")
  set(CMAKE_CXX_COMPILER_VERSION_DOT "${major_version}.${release_version}" CACHE STRING "GCC version")
  mark_as_advanced(CMAKE_CXX_COMPILER_VERSION_DOT)
elseif(CMAKE_CXX_COMPILER_ID MATCHES "Clang") # Clang or AppleClang
  set(OIV_CXX_COMPILER_ID "clang")
  string(SUBSTRING ${CMAKE_CXX_COMPILER_VERSION} 0 1 major_version)
  string(SUBSTRING ${CMAKE_CXX_COMPILER_VERSION} 2 1 release_version)
  set(OIV_CXX_COMPILER_VERSION "${major_version}${release_version}" CACHE STRING "Clang version used for prepacked")
  set(CMAKE_CXX_COMPILER_VERSION_DOT "${major_version}.${release_version}" CACHE STRING "Clang version")
  mark_as_advanced(CMAKE_CXX_COMPILER_VERSION_DOT)
endif()

set(CMAKE_ARCHITECTURE "${CMAKE_CXX_PLATFORM_ID}-x86_64-${OIV_CXX_COMPILER_ID}${OIV_CXX_COMPILER_VERSION}")
set(CMAKE_ARCHITECTURE_LONG "${CMAKE_ARCHITECTURE}-${CMAKE_BUILD_TYPE}")

if(WIN32)
  if(CMAKE_BUILD_TYPE)
    set(OIVARCH "arch-${CMAKE_ARCHITECTURE}-${CMAKE_BUILD_TYPE}")
  else()
    set(OIVARCH "arch-${CMAKE_ARCHITECTURE}-${CMAKE_CFG_INTDIR}")
  endif()
else()
  string(TOLOWER "${CMAKE_BUILD_TYPE}" _build_type)
  set(OIVARCH "arch-${CMAKE_ARCHITECTURE}-${_build_type}")
endif()

message(STATUS "Building for architecture ${CMAKE_ARCHITECTURE}")
