import oiv_common
import sys
import os
import locale
import glob

from multiprocessing import Pool

artFileDirectory = sys.argv[1]
executable = sys.argv[2]
print("executable: " + executable)
outputDir = sys.argv[3]
print("outputDir: " + outputDir)
referencesDir = sys.argv[4]
print("referencesDir: " + referencesDir)
testName = sys.argv[5]
print("testName: " + testName)
testParam = sys.argv[6]
print("testParam: " + testParam)
pargeHeap = sys.argv[7]
branch_name = sys.argv[8]
gitSha = sys.argv[9]
exitCode = 0
useNewTest = 0

oivTestConfName = os.environ["OIV_TEST_CONF_NAME"]
testNameWithConf = testName
if oivTestConfName == "default":
    oivTestConfName = ""
else:
    testNameWithConf = oivTestConfName + "_" + testNameWithConf


def compareImageHelper(image):
    return oiv_common.compareImage(image, outputDir, referencesDir, oivTestConfName)

# ensure the global variable is set in oiv_common
# this needs to be done for every thread
oiv_common.setBranchName(branch_name)

# ---------------------------------------------------------------------------------------
#                                   MAIN
# ---------------------------------------------------------------------------------------
if __name__ == '__main__':

    # make sure the output is unbuffered, as otherwise the dart output
    # from the threads would come after those from the main thread
    sys.stdout = oiv_common.Unbuffered(sys.stdout)

    #-----------------------------------------------
    # Specific Environement variables
    #-----------------------------------------------
    os.environ["OIV_ART_CATCHSIGNALS"] = "1"
    os.environ["LDM_FORCE_FIXED_RES"] = "1"
    os.environ["DIRECTVIZ_RT_INIT"] = "-rt:log off"

    #-----------------------------------------------
    # 1 - Run art and check the result
    #-----------------------------------------------

    # define the warning and error level as a percent of result difference for output bench.
    # 2% leads to warning. The bench is marked as PASSED
    warnLimit = 10
    # 4% leads to error. The bench is marked as FAILED
    errorLimit = 20
    locale.setlocale(locale.LC_ALL, 'C')

    try:
        if not os.path.exists(outputDir):
            os.makedirs(outputDir)
    except IOError as e:
        print("I/O error({0}): {1}".format(e.errno, e.strerror))
    else:
        os.chdir(artFileDirectory)

    testParam = str.replace(testParam, ";", " ")

    if pargeHeap == "1":
        oiv_common.enablePageHeap("ART.exe")

    returnCode = oiv_common.runProgram(executable + " " + testParam)

    if pargeHeap == "1":
        oiv_common.disablePageHeap("ART.exe")

    if returnCode != 0:
        exitCode = returnCode

    #-----------------------------------------------------
    # 1.5 - Set cdash server
    #-----------------------------------------------------
    oiv_common.setCdashServer("frbor-cdash01/api/v1")
    oiv_common.dartOutputCommitButton(referencesDir)

    #-----------------------------------------------
    # 2 - Compare the images
    #-----------------------------------------------

    p = Pool(4)

    if len(glob.glob(outputDir + "/" + testNameWithConf + "*.png")) > 0:
        images = glob.glob(outputDir + "/" + testNameWithConf + "*.png")
        images = [i for i in images if i.find("diff_") == -1]
        result = p.map(compareImageHelper, images)
        exitCode = len([i for i in result if i != 0])
    elif len(glob.glob(referencesDir + "/*" + testName + "*.png")) > 0:
        oiv_common.dartOutput("No Generated Image Found", "with pattern: '" + outputDir + "/" + testNameWithConf + "*.png'", hasError=True)

        exitCode = 1

    # make sure the images comparisons have finished before outputting the rest
    p.close()
    p.join()

    #-----------------------------------------------
    # 3 - Compare the outputs
    #-----------------------------------------------
    returnCode = oiv_common.compareOutput(testName, outputDir, referencesDir, warnLimit, errorLimit, oivTestConfName)

    if returnCode != 0:
        exitCode = returnCode

    #-----------------------------------------------
    # End of Main function
    #-----------------------------------------------
    if returnCode != 0:
        oiv_common.dartOutput("return code", str(returnCode))
        if oiv_common.file_exists(outputDir + "/" + testNameWithConf + "_stdout.log"):
            oiv_common.dartOutputFile("Standard output content", outputDir + "/" + testNameWithConf + "_stdout.log")
        if oiv_common.file_exists(outputDir + "/" + testNameWithConf + "_stderr.log"):
            oiv_common.dartOutputFile("Error output content", outputDir + "/" + testNameWithConf + "_stderr.log")
        # End with error code
        exitCode = 1

    oiv_common.dartOutputGitSha(gitSha)
    #Print the environment and the OIV_CONFIG_FILE
    oiv_common.dartOutputEnv()
    if "OIV_CONFIG_FILE" in os.environ:
        configFile = os.environ["OIV_CONFIG_FILE"]
        if os.path.exists(configFile):
            oiv_common.dartOutputFileExpand("OivConfig", configFile, keepComment=False)

    print("exitcode: " + str(exitCode))
    sys.exit(exitCode)
