/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/


#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <X11/Xlib.h>
#include <Inventor/sys/SoGL.h>
#include <Inventor/sys/SoGLX.h>
#include <Inventor/sys/glew.h>
#include <Inventor/SoDB.h>

static const char *Format(int n, int w);

#ifndef GLX_SAMPLE_BUFFERS_ARB
#  define GLX_SAMPLE_BUFFERS_ARB 100000
#endif

#ifndef GLX_SAMPLES_ARB
#  define GLX_SAMPLES_ARB 100001
#endif


int
main(int , char **)
{
  // Despite no explicit invocation of any
  // Open Inventor object is present
  // in the following code, nevertheless
  // it is necessary to initialize SoDB
  // before calling any glXCreateContext method.
  // As a matter of fact glXCreateContext and other methods 
  // are wrapped by Open Inventor and they need 
  // static data structure to be initialized.
  SoDB::init();

  Display *dpy;
  XVisualInfo match, *visualList, *vi, *visualToTry;
  int errorBase, eventBase, major, minor, found;
  int glxCapable, bufferSize, level, renderType, doubleBuffer, stereo,
    auxBuffers, redSize, greenSize, blueSize, alphaSize, depthSize,
    stencilSize, acRedSize, acGreenSize, acBlueSize, acAlphaSize;

  dpy = XOpenDisplay(NULL);
  if (!dpy) {
    fprintf(stderr, "Can NOT open display %s\n", XDisplayName(NULL));
   exit(1);
  }
  if (!glXQueryExtension(dpy, &errorBase, &eventBase)) {
    fprintf(stderr, "OpenGL not supported by X server.\n");
    exit(1);
  }

  glXQueryVersion(dpy, &major, &minor);
  printf("DISPLAY: %s\n", XDisplayName(NULL));
  printf("Using GLX version: %d.%d\n\n", major, minor);

  match.screen = DefaultScreen(dpy);
  visualList = XGetVisualInfo(dpy, VisualScreenMask, &match, &found);

  visualToTry = NULL;
  for(vi = visualList; found > 0; found--, vi++) {
    glXGetConfig(dpy, vi, GLX_USE_GL, &glxCapable);
    if (glxCapable) {
      visualToTry = vi;
      break;
    }
  }
  
  int fsaaAvailable = 0;

  if (visualToTry) {
    GLXContext context;
    Window window;
    Colormap colormap;
    XSetWindowAttributes swa;

    context = glXCreateContext(dpy, visualToTry, 0, GL_TRUE);
    colormap = XCreateColormap(dpy, RootWindow(dpy, visualToTry->screen),
                               visualToTry->visual, AllocNone);
    swa.colormap = colormap;
    swa.border_pixel = 0;
    window = XCreateWindow(dpy, RootWindow(dpy, visualToTry->screen), 0, 0, 100, 100,
                           0, visualToTry->depth, InputOutput, visualToTry->visual,
                           CWBorderPixel | CWColormap, &swa);
    bool ok = glXMakeCurrent(dpy, window, context);
    if (ok)
    {
      GLenum err = glewInit();
      if (GLEW_OK != err)
      {
        /* Problem: glewInit failed, something is seriously wrong. */
        fprintf(stderr, "Error: %s\n", SoGLEW::glewGetErrorString(err));
      }
      fprintf(stdout, "Status: Using GLEW %s\n", SoGLEW::glewGetString(GLEW_VERSION));
      printf("GL vendor string: %s\n", glGetString(GL_VENDOR));
      printf("GL renderer string: %s\n", glGetString(GL_RENDERER));
      printf("GL version string: %s\n", glGetString(GL_VERSION));
      printf("Direct rendering: %ssupported\n", (glXIsDirect(dpy, context) ? "" : "NOT "));

      char *p = (char *)glGetString(GL_EXTENSIONS);
      if (p) {
        char *end = p + strlen(p);
      
        printf("GL extensions :");
        while (p < end) {
          char tmp[256];
          int n = strcspn(p, " ");
        
          strncpy(tmp, p, n);
          tmp[n] = '\0';
          printf("  %s\n", tmp);
	  if (!fsaaAvailable && !strcmp(tmp, "GL_ARB_multisample"))
	    fsaaAvailable = 1;
          p += (n + 1);
        }
      }

#if defined(GLX_VERSION_1_1)
      p = (char *)glXQueryExtensionsString(dpy, visualToTry->screen);
      if (p) {
        char *end = p + strlen(p);
      
        printf("GLX extensions :\n");
        while (p < end) {
          char tmp[256];
          int n = strcspn(p, " ");
        
          strncpy(tmp, p, n);
          tmp[n] = '\0';
          printf("  %s\n", tmp);
	  if (!fsaaAvailable && !strcmp(tmp, "GLX_ARB_multisample"))
	    fsaaAvailable = 1;
           p += (n + 1);
        }
      }
#endif
    }
  }
  else {
    printf("No GLX-capable visuals!\n");
  }

  printf("\n\n   visual     bf lv rg d st  r  g  b a  ax dp st accum buffs samples\n");
      printf(" id dep cl    sz l  ci b ro sz sz sz sz bf th cl  r  g  b  a  nbr\n");
  printf("--------------------------------------------------------------------\n");

  visualToTry = NULL;
  for(vi = visualList; found > 0; found--, vi++) {
    glXGetConfig(dpy, vi, GLX_USE_GL, &glxCapable);
    if (glxCapable) {
      printf("0x%lu %2d %s", vi->visualid, vi->depth, "--");
      glXGetConfig(dpy, vi, GLX_BUFFER_SIZE, &bufferSize);
      glXGetConfig(dpy, vi, GLX_LEVEL, &level);
      glXGetConfig(dpy, vi, GLX_RGBA, &renderType);
      glXGetConfig(dpy, vi, GLX_DOUBLEBUFFER, &doubleBuffer);
      glXGetConfig(dpy, vi, GLX_STEREO, &stereo);
      glXGetConfig(dpy, vi, GLX_AUX_BUFFERS, &auxBuffers);
      glXGetConfig(dpy, vi, GLX_RED_SIZE, &redSize);
      glXGetConfig(dpy, vi, GLX_GREEN_SIZE, &greenSize);
      glXGetConfig(dpy, vi, GLX_BLUE_SIZE, &blueSize);
      glXGetConfig(dpy, vi, GLX_ALPHA_SIZE, &alphaSize);
      glXGetConfig(dpy, vi, GLX_DEPTH_SIZE, &depthSize);
      glXGetConfig(dpy, vi, GLX_STENCIL_SIZE, &stencilSize);
      glXGetConfig(dpy, vi, GLX_ACCUM_RED_SIZE, &acRedSize);
      glXGetConfig(dpy, vi, GLX_ACCUM_GREEN_SIZE, &acGreenSize);
      glXGetConfig(dpy, vi, GLX_ACCUM_BLUE_SIZE, &acBlueSize);
      glXGetConfig(dpy, vi, GLX_ACCUM_ALPHA_SIZE, &acAlphaSize);
      printf("    %2s %2s %1s  %1s  %1s ",
             Format(bufferSize, 2), Format(level, 2),
             renderType ? "r" : "c",
             doubleBuffer ? "y" : ".", 
             stereo ? "y" : ".");
      printf("%2s %2s %2s %2s ",
             Format(redSize, 2), Format(greenSize, 2),
             Format(blueSize, 2), Format(alphaSize, 2));
      printf("%2s %2s %2s %2s %2s %2s %2s",
             Format(auxBuffers, 2), Format(depthSize, 2), Format(stencilSize, 2),
             Format(acRedSize, 2), Format(acGreenSize, 2),
             Format(acBlueSize, 2), Format(acAlphaSize, 2));

      if (fsaaAvailable) {
	int samp, nsamp;
	glXGetConfig(dpy, vi, GLX_SAMPLE_BUFFERS_ARB, &samp);
	glXGetConfig(dpy, vi, GLX_SAMPLES_ARB, &nsamp);
	printf(" %2d %2d", samp, nsamp);
      }
      else {
        printf("  0");
      }
      printf("\n");
      visualToTry = vi;
    }
  }

  XFree(visualList);
  SoDB::finish();
  return 0;
}

static const char *
Format(int n, int w)
{
  static char buffer[256];
  static size_t bufptr = 0;
  char *buf;

  if (bufptr >= sizeof(buffer) - w) {
    bufptr = 0;
  }
  buf = buffer + bufptr;
  if (n == 0) {
    sprintf(buf, "%*s", w, ".");
  }
  else {
    sprintf(buf, "%*d", w, n);
  }
  bufptr += w + 1;
  return buf;
}


