import sys
import getopt
import re
import os

# You can change the extensions here
_searched_extenstions = ['.cpp', '.cxx', '.h']
_srcRootDir = ""
_logFile = ""


def usage():
    print("usage: {} Options".format(sys.argv[0]))
    print("Generate a list of all OpenGL functions used by Open Inventor, annotated by OpenGL Version.")
    print("OPTIONS:")
    print("-r <SourceRootDir> Main directory where to loo for source to parsedirectory")
    print("-o <OutputFile> file to store the generated output. If not specified, output is displayed in console")
    print("-g <GLFilesDirectory> Directory where to find all the .names files. Default is the same as this script")


# Some comestic display
def displayResults(foundIn, foundWhat, lineNumber, functionCall):
    if _logFile != "":
        print >> _logFile, foundIn.replace(_srcRootDir, ""), " : ", os.path.split(foundWhat)[1].replace(".names", ""), " : ", str(lineNumber), " : ", functionCall.replace("\n", "")
    else:
        print("{} : {} : {} : {}".format(foundIn.replace(_srcRootDir, ""), os.path.split(foundWhat)[1].replace(".names", ""), lineNumber, functionCall))


def main(argv):
    #Some Global definitions
    global _srcRootDir
    global _logFile

    # Default directoy to fing .names file is same directory as python script
    glNamesFilesDir = os.path.dirname(os.path.abspath(__file__))
    outputFile = ""

    if len(sys.argv) == 1:
        usage()
        sys.exit(2)

    try:
        opts, args = getopt.getopt(argv, "hr:o:d:g:")
    except getopt.GetoptError:
        usage()
        sys.exit(2)

    for opt, arg in opts:
        if opt == '-h':
            usage()
            sys.exit()
        elif opt == '-r':
            _srcRootDir = arg
        elif opt == '-o':
            outputFile = arg
        elif opt == '-g':
            glNamesFilesDir = arg
        else:
            print(opt)

    file_names = []
    glFileNames = []
    extList = []

    # Get the list of files we are interested in. We list here all
    # files under <SourceRootDir>.
    print("Gathering source files according to extension list " + str(_searched_extenstions))
    for root, _, files in os.walk(_srcRootDir):
        file_names = file_names + [os.path.join(root, fn) for fn in files if any(fn.endswith(ext) for ext in _searched_extenstions)]
    print("Done. Found {} matching files".format(len(file_names)))

    # List all the GL filenames here
    print("Gathering '*.names' files from directory  " + glNamesFilesDir)
    for root, _, files in os.walk(glNamesFilesDir):
        glFileNames = glFileNames + [os.path.join(root, fn) for fn in files if fn.endswith(".names") and os.stat(os.path.join(root, fn)).st_size != 0]
    print("Done. Found {} matching files".format(len(glFileNames)))

    # Before starting to open the file (if requested) to log output.
    # Will avoid opening/closing it each time we need to log something
    if outputFile != "":
        _logFile = open(outputFile, 'w')

    # Now we have all extension and all concerned files, just browse
    print("Browsing code looking for GL extension...")

    # 1- We loop over all the matching source file
    for srcFile in file_names:
        # 2- For each extension file of .names files list
        for extFile in glFileNames:
            # 3- Build a regexp based on items found in current .names file
            extList = [line.rstrip() for line in open(extFile)]
            extListRe = re.compile('|'.join(extList))
            with open(srcFile) as openedSrcFile:
                # 4- Loop in current source file to find matching lines
                for num, line in enumerate(openedSrcFile, 1):
                    if extListRe.search(line):
                        # Found one line, display result and some info
                        displayResults(srcFile, extFile, num, line)
    print("Done.")

    # Close our log file
    if outputFile != "":
        _logFile.close()
        print("Result saved in " + outputFile)


main(sys.argv[1:])
