/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG David Beilloin (Jul 2014)
**=======================================================================*/

// CAD file to Open Inventor utility
// Read a CAD file file and save it 
// to an Open Inventor file

#include <stdio.h> 
#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/actions/SoWriteAction.h>
#include <Inventor/nodes/SoSeparator.h>

#if defined(ENABLE_CAD_SUPPORT)
#include <Inventor/io/CAD/SoCADFileFormat.h>
#include <Inventor/io/CAD/SoCADInputReaderParameters.h>
#endif // ENABLE_CAD_SUPPORT

int
main(int argc, char *argv[])
{
  // Check input parameters are valid
  if (argc < 2 || strcmp(argv[1], "-h") == 0)
  {
    printf("Convert suported file to Open Inventor iv file\n");
    printf("Usage: %s [fileToConvert]\n",argv[0]);
    printf("Copyright FEI S.A.S.\n");
	return 0;
  }

  // Initialized Open Inventor
  SoDB::init();

  // Create object to handle input file
  SoInput cadInput;

#if defined(ENABLE_CAD_SUPPORT)
  SoCADFileFormat::init();

  // You can optionnaly set a number of specific CAD import parameters
  SoCADInputReaderParameters parameters;

  // 1. setup Tesselation parameters can be set in two different ways
  {
    // 1.1- give a hint and let Open Inventor setup the attribute accordingly
    parameters.setTessellationOption( SoCADInputReaderParameters::MEDIUM);

    // 1.2- set more precisely each attributes available int TesselationOption
    //SoCADInputReaderParameters::TessellationOption tessellation;
    //tessellation.angularTolerance = 0.5;
    //tessellation.linearTolerance = 0.1;
    //tessellation.maxTriangleEdgesRatio = 5.0f;
    //parameters.setTessellationOption( tessellation );
  }

  // 2. setup import option
  {
    SoCADInputReaderParameters::ImportOption import;
    import.importEdges = true;
    import.importOpenShells = true;
    import.importPMI = true;
    import.mergeFaces = true;
    parameters.setImportOption (import);
  }
  cadInput.setInputParameters( &parameters );
#endif // ENABLE_CAD_SUPPORT

  if (!cadInput.openFile(argv[1]))
  {
    printf("Cannot open file \"%s\"...\n", argv[1]);
    return -1;
  }

  // launch the read/convert process
  printf("Reading File: %s ...",argv[1]);
  {
    SoRef<SoSeparator> fileContents = SoDB::readAll(&cadInput);
    if (fileContents.ptr() == NULL)
    {
      printf("Unable to read from file \"%s\" ...\n", argv[1]);
      return -1;
    }
    printf("OK.\n");

    // setup the output filename to write the result to "sourceFilename+.iv"
    SbString outputFileName = argv[1];
    outputFileName += ".iv";

    printf("Writing File: %s ...",outputFileName.toLatin1());
    SoWriteAction myAction;
    myAction.getOutput()->openFile(outputFileName);
    myAction.getOutput()->setBinary(TRUE);
    myAction.apply(fileContents.ptr());
    myAction.getOutput()->closeFile();
    printf("OK.\n");
  }

#if defined(ENABLE_CAD_SUPPORT)
  SoCADFileFormat::finish();
#endif // ENABLE_CAD_SUPPORT

  SoDB::finish();
  return 0;
}
