/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

//
// Code for the edges class, that supports fast querying of the faces
// around an edge.
//

struct Edge
{
    Edge() { v1 = v2 = (-1); }
    int32_t v1, v2;
    FaceList faces;
};

class EdgeDict
{
  public:
    EdgeDict(int initial_size = 500);
    ~EdgeDict();

    void Add(Face *, int32_t v1, int32_t v2);

    void OtherFaces(Face *, int32_t v1, int32_t v2, FaceList &result);

  private:

    // Add to hash table.  Will create an entry if necessary.
    Edge *Enter(int32_t v1, int32_t v2);

    // Search for an edge; returns NULL if not found
    Edge *Find(int32_t v1, int32_t v2);

    int HashFunc(int32_t v1, int32_t v2);
    void ReHash(int new_size);

    Edge *hash_table;
    int n_hash;	// length of hash table
    int n_edges;	// # of edges added to hash table
};


