/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/
#ifndef _FACES_
#define _FACES_


//
// A convenient representation for faces
//

#include <Inventor/misc/SoBasic.h>
#include <Inventor/SbPList.h>
#include <Inventor/SbVec.h>

class EdgeDict;
class SbVec3f;
class SoNormal;
class SoIndexedFaceSet;
class SoMFVec3f;

class Face
{
  public:
    int nv;	// Number of vertices
    int32_t *v;	// Pointers to indices, which are vertices...
    int32_t *vn;	// Indices for vertex normals
    int	vct;	// count of the first vertex in the original IFS node
    int vidx;	// index of the first vertex in the original IFS node
    int degenerate;	// Is it degenerate? (set by findNormal)
    int body;	// which body does it belong to?

    SbVec3f normal;	// Face normal for the whole face

    enum Orientation {
	UNKNOWN,
	CW,
	CCW
    };
    Orientation orientation;

    void findNormal(const SbVec3f *verts);
    void orientFace(int, int);

};

class FaceList : public SbPList
{
  public:
    FaceList();
    FaceList(const SbVec3f *, SoIndexedFaceSet *, SbBool verbose=FALSE);
    ~FaceList();

    void append(Face *f);

    Face * operator[](int i) const
        { return (Face *)SbPList::operator[](i);}

    void findOrientation();
    void correctOrientation();
    void findFacetNormals(SoNormal *);
    void findVertexNormals(SoNormal *, SoIndexedFaceSet *, float);

    void findShapeInfo();	// sets isSolid() and isConvex() appropriately
    int isSolid() { return solid; }
    int isConvex() { return convex; }

    int findBodies();		// sets faces' body field.  returns # bodies
    void extractBody(int b,
		int &nFaces, int32_t *fNewFromOld, int32_t *fOldFromNew,
		int &nVertices, int32_t *vNewFromOld, int32_t *vOldFromNew);
    SoIndexedFaceSet	*getFaceSet() { return faceSet; }

    void setVerbose(SbBool v) { verbose = v; }
    SbBool isVerbose() const { return verbose; }


  private:
    FaceList(const SbVec3f *, EdgeDict *);
    float volume();
    void reverseOrientation();	// reverse orientation of all on list
    void recursivelyOrient(Face *);
    void recursivelyMarkBody(Face *);
    void orientOutward();
    void averageNormals(SoMFVec3f &, SbVec3f &, float, int);
    void buildVertexDict();

    int convex;
    int solid;
    const SbVec3f *verts;
    EdgeDict *ed;
    FaceList	*vd;	// vertex dictionary
    int		vdSize;
    SoIndexedFaceSet *faceSet;

    SbBool verbose;

    static int getIdx(SoMFVec3f &mf, const SbVec3f &p);
};

//
// v2 vs v3.1 compiler hacks
//
#ifndef INVENTOR1
typedef Face::Orientation	FaceOrientation; 	// v3.1
#else
typedef Orientation		FaceOrientation;	// v2
#endif

#endif


