/*=======================================================================
 * Copyright 1991-1996, Silicon Graphics, Inc.
 * ALL RIGHTS RESERVED
 *
 * UNPUBLISHED -- Rights reserved under the copyright laws of the United
 * States.   Use of a copyright notice is precautionary only and does not
 * imply publication or disclosure.
 *
 * U.S. GOVERNMENT RESTRICTED RIGHTS LEGEND:
 * Use, duplication or disclosure by the Government is subject to restrictions
 * as set forth in FAR 52.227.19(c)(2) or subparagraph (c)(1)(ii) of the Rights
 * in Technical Data and Computer Software clause at DFARS 252.227-7013 and/or
 * in similar or successor clauses in the FAR, or the DOD or NASA FAR
 * Supplement.  Contractor/manufacturer is Silicon Graphics, Inc.,
 * 2011 N. Shoreline Blvd. Mountain View, CA 94039-7311.
 *
 * THE CONTENT OF THIS WORK CONTAINS CONFIDENTIAL AND PROPRIETARY
 * INFORMATION OF SILICON GRAPHICS, INC. ANY DUPLICATION, MODIFICATION,
 * DISTRIBUTION, OR DISCLOSURE IN ANY FORM, IN WHOLE, OR IN PART, IS STRICTLY
 * PROHIBITED WITHOUT THE PRIOR EXPRESS WRITTEN PERMISSION OF SILICON
 * GRAPHICS, INC.
**=======================================================================*/
/*=======================================================================
** Author      : SGI (MMM YYYY)
**=======================================================================*/

//
// Definition for a class that trys to orient a surface and find
// normals for it.
//

#include "Faces.h"

class SoNode;
class SoPath;
class SoMFVec3f;
class SoNormal;

class FindNormals
{
  public:
    FindNormals();
    ~FindNormals();

    //
    // If the application knows that the faces are already
    // consistently oriented (default is UNKNOWN):
    //
    void AssumeOrientation(FaceOrientation);

    //
    // Pass TRUE if this should find vertex normals
    // Pass FALSE if not.
    //
    void findVertexNormals(int);

    // If finding vertex normals, pass in the angle (in radians)
    // beyond which a sharp edge should be formed.
    void setCreaseAngle(float c) { creaseAngle = c; }

    //
    // This finds normals in the given scene graph, and inserts
    // Normal and NormalBinding nodes into the scene graph.  It may
    // also modify the fields in IndexedFaceSet nodes to correct
    // mis-oriented faces and to set the normalIndex field.
    //
    void apply(SoNode *, int);

    //
    // turn on trace output
    //
    void setVerbose(SbBool v) { verbose = v; }
    SbBool isVerbose() const { return verbose; }

  private:
    FaceOrientation defaultOrientation;
    float creaseAngle;

    SoNode *searchLastType(SoPath *, SoType);
    void doIndexedFaceSet(SoPath *, int);

    SbBool verbose;
};


