/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef BENCHER_H
#define BENCHER_H

#include <Inventor/SbString.h>
#include <Inventor/nodes/SoShape.h>
#include <Inventor/nodes/SoDrawStyle.h>

#include <geometry.h>

#include <string>
#include <vector>

class Viewer;
class SoQtRenderArea;

#define MAX_SHAPES 10000

class MemoryTool
{
public:

  static unsigned long long current();

  static unsigned long long peak();
};

class BenchTool
{
public:

  struct BenchResult
  {
    int id;
    unsigned long long beforeMemoryUsage;
    unsigned long long beforeRenderingMemoryUsage;

    unsigned long long afterFirstFrameMemoryUsage;
    unsigned long long afterSecondFrameMemoryUsage;
    unsigned long long afterThirdFrameMemoryUsage;

    unsigned long long afterRenderingMemoryUsage;

    unsigned long long afterCleanUpMemoryUsage;

    unsigned long long peakMemoryUsage;

    float firstFrameTime;
    float secondFrameTime;
    float thirdFrameTime;

    /** Global FPS including the first two frames */
    float globalFps;

    /** FPS without the first three frames */
    float remainingFps;

    std::string nodeName;
    std::string benchString;
    std::string sshotFilename;
    std::string ivFilename;
    std::string configName;

    /** Can be useful for the output */
    GeometryTool::GeometryInfo shapeInfo;
  };

  struct BenchData
  {
    // Settings
    // - ID
    int id;
    std::string benchString;
    SbString configName;

    // - Geometry
    int shapesCount;
    SoDrawStyle::Style drawStyle;
    GeometryTool::GeometryInfo shapeInfo;

    // - Bench running parameters
    int frameNum;
    int frameStart;
    int frameEnd;
    int frameStepping;

    // DO NOT SET THOSE VARIABLES
    // They are automatically computed by the bench function
    SoNode* shapeInstance[ MAX_SHAPES ];
  };

  BenchTool();

  ~BenchTool();

  std::vector< BenchResult > bench(std::string outputDir, Viewer* viewer, std::string benchString);

  std::vector< BenchResult > bench(std::string outputIvFile, bool outputDisplay,
    std::string outputDisplayFile, Viewer* viewer,
    std::string benchString);

  std::vector< BenchResult > bench(std::string outputIvFile, bool outputDisplay,
    std::string outputDisplayFile, Viewer* viewer,
    BenchData benchData, std::string geometryType);

  static std::string buildTestBunch(std::string flags, std::string bindingFlags,
    std::string indexedBindingFlags,
    int geomIndex,
    int geomWidth, int geomHeight, int geomCount,
    int frameCount, int frameStart, int frameEnd, int frameStepping,
    std::string config);

  static void nodeToGeometryInfo(SbString nodeName, BenchData& benchData);

  static void getGeometryFromNode( const SbString &nodeName, GeometryTool::GeometryInfo &outGeomInfo, SoNode* &pNodeOut );

protected:

  void decodeBenchString(std::string str);

  void buildGeometry(BenchData& benchData, SbString nodeName);

  void performBench(std::string outputIvFile, 
    bool outputDisplay, std::string outputDisplayFile,
    Viewer* viewer, BenchData benchData);


  GeometryTool::BindingType getBinding(char flag);

  static SbBool staticRenderCallback(void* userData, SoQtRenderArea* rendArea);

  SbBool renderCallback(void* userData, SoQtRenderArea* rendArea);

private:

  std::vector< BenchData > m_benchData;
  std::vector< BenchResult > m_benchResults;

  int m_framesCount;
  int m_framesSinceLastAnimation;
};


#endif // BENCHER_H


