#ifndef GEOMETRY_H
#define GEOMETRY_H

class SoShape;
class SoNode;
class SoVertexShape;
class SoBufferedShape;

class GeometryTool
{
public:

  enum  GeometryType
  {
    POINTS,
    LINES,
    LINE_STRIP,
    LINE_LOOP,
    TRIANGLES,
    TRIANGLE_STRIP,
    TRIANGLE_FAN,
    QUADS,
    QUAD_STRIP,
    POLYGON
  };

  enum BindingType
  {
    INVALID = -1,
    OVERALL = 0,
    PER_FACE,
    PER_VERTEX,
    PER_FACE_INDEXED,
    PER_VERTEX_INDEXED
  };

  struct GeometryInfo
  {
    // Geometry parameters
    GeometryType type;

    // 0 regular sinus mesh, 1 for the sinus mesh with an hole.
    int geomIndex;

    // For a regular sinus mesh
    int width;
    int height;
    float amplitude;

    int xOffset; 
    int yOffset;
    int zOffset;

    // Binding 
    BindingType colorsBinding;
    BindingType normalsBinding;
   
    // Extra attributs
    bool isIndexed;
    bool isStrip;
    bool isPrimitiveRestart;
    bool isBufferedShape;

    bool hasNormals;
    bool hasColors;
    bool hasTexCoords;
    bool hasTexCoords3;
    bool hasVertexAttribs;
    float neighborTolerance;

    // Computed by the generator
    int numVertices;
    int numPrimitives;
    bool hasHoles;
  };

  static BindingType getBindingType( const char& value );

  static void generateGeometry( SoNode* shapeNode, GeometryInfo& info );

private:

  static void generateSimplePrimitive( SoVertexShape* vertexShape, GeometryInfo& info, int count );

  static void setupSimplePrimitiveIndices( SoVertexShape* vertexShape, GeometryInfo& info, int count );
  
  static void generateHole( SoVertexShape* vertexShape, GeometryInfo& info, int count );

  static void setupHoleIndices( SoVertexShape* vertexShape, GeometryInfo& info, int count );



  static void generateSimplePrimitive( SoBufferedShape* vertexShape, GeometryInfo& info, int count );

  static void setupSimplePrimitiveIndices( SoBufferedShape* vertexShape, GeometryInfo& info, int count );
  
  static void generateHole( SoBufferedShape* vertexShape, GeometryInfo& info, int count );

  static void setupHoleIndices( SoBufferedShape* vertexShape, GeometryInfo& info, int count );


  static float* generateVertices( GeometryInfo& info );

  static float* generateColors( GeometryInfo& info, float* vertices );

  static float* generateNormals( GeometryInfo& info, float* vertices );

  static float* generateTexCoords( GeometryInfo& info, float* vertices );
  
  static float* generateTexCoords3( GeometryInfo& info, float* vertices );

  static int getOivBinding( BindingType binding );

};


#endif // GEOMETRY_H


