#!bash
outputIvDir=$1

echo "# Generation IV files with IvShapeBenchmark"

if [ $# -ne 1 ]; then
  echo "Usage: ivFilesGeneration.sh <outputDirectory>"
  exit 1
fi


if [ ! -d "$outputIvDir" ]; then
    echo "Output IV directory does not exist"
    echo "Generation aborted"
    exit 1
  fi

ivShapeBenchmarkFolder="$OIVHOME/$OIVARCH/bin"
outputDirUnix="${outputIvDir//\\/\/}"

echo "Use $ivShapeBenchmarkFolder/ivShapeBenchmark for generation"
echo "Output IV directory: $outputDirUnix"


testCases=(
"VC WW F 0 86 112 2 10 0 -1 1 STANDALONE"
"VT WW F 0 86 112 2 10 0 -1 1 STANDALONE"
"V3 WW F 0 86 112 2 10 0 -1 1 STANDALONE"
"VC GG F 0 86 112 2 10 0 -1 1 STANDALONE"
"VT GG F 0 86 112 2 10 0 -1 1 STANDALONE"
"V3 GG F 0 86 112 2 10 0 -1 1 STANDALONE"
"VCTA WW F 0 43 66 2 10 0 -1 1 STANDALONE"
"VC3A WW F 0 43 66 2 10 0 -1 1 STANDALONE"
"VC WW L 0 33 46 2 10 0 -1 1 STANDALONE"
"VC WW P 0 33 46 2 10 0 -1 1 STANDALONE"
"V WF F 0 200 200 1 10 0 -1 1 10e-6 STANDALONE"
"V WF F 0 10 10 1000 10 0 -1 1 10e-6 STANDALONE"
"V WW F 0 2 2 500 10 0 -1 1 10e-6 STANDALONE"
"V WW F 0 2 3 500 10 0 -1 1 10e-6 STANDALONE"
)

shapes=(
"TriangleSet"
"FaceSet:3"
"QuadMesh"
"TriangleStripSet"
"IndexedTriangleSet"
"IndexedFaceSet:3"
"IndexedQuadMesh"
"IndexedTriangleStripSet"
"PointSet"
"LineSet"
"BufferedPOINTS"
"BufferedLINES"
"BufferedLINE_STRIP"
"BufferedLINE_LOOP"
"BufferedTRIANGLES"
"BufferedTRIANGLE_STRIP"
"BufferedTRIANGLE_FAN"
"BufferedQUADS"
"BufferedQUAD_STRIP"
"BufferedPOLYGON"
"IndexedBufferedPOINTS"
"IndexedBufferedLINES"
"IndexedBufferedLINE_STRIP"
"IndexedBufferedLINE_LOOP"
"IndexedBufferedTRIANGLES"
"IndexedBufferedTRIANGLE_STRIP"
"IndexedBufferedTRIANGLE_FAN"
"IndexedBufferedQUADS"
"IndexedBufferedQUAD_STRIP"
"IndexedBufferedPOLYGON"
"IndexedPRBufferedLINE_STRIP"
"IndexedPRBufferedTRIANGLE_STRIP"
"IndexedPRBufferedQUAD_STRIP"
"TriangleSet"
"FaceSet:3"
"QuadMesh"
"TriangleStripSet"
"IndexedTriangleSet"
"IndexedFaceSet:3"
"IndexedQuadMesh"
"IndexedTriangleStripSet"
"BufferedTRIANGLES"
"BufferedTRIANGLE_STRIP"
"BufferedTRIANGLE_FAN"
"BufferedQUADS"
"BufferedQUAD_STRIP"
"BufferedPOLYGON"
"IndexedBufferedTRIANGLES"
"IndexedBufferedTRIANGLE_STRIP"
"IndexedBufferedTRIANGLE_FAN"
"IndexedBufferedQUADS"
"IndexedBufferedQUAD_STRIP"
"IndexedBufferedPOLYGON"
"IndexedPRBufferedTRIANGLE_STRIP"
"IndexedPRBufferedQUAD_STRIP"
)


for shape in ${!shapes[@]}
do
  shapeName="${shapes[$shape]}"
  shapeNameNoColon="${shapeName//:/-}"
  echo "Generation for shape $shapeName"
  if [ ! -d "$outputDirUnix/$shapeNameNoColon" ]; then
    echo "output directory does not exist"
    echo "create directory : $outputDirUnix/$shapeNameNoColon"
    mkdir $outputDirUnix/$shapeNameNoColon
  fi

  for test in ${!testCases[@]}
  do
    parameters="${testCases[$test]}"
    parameters_completed="$shapeName $parameters"
    file_name_no_space="${parameters_completed//[[:space:]]/_}"
    file_name="$file_name_no_space"
    file_name_no_colon="${file_name//:/-}"
    complete_file_dir="$outputDirUnix/$shapeNameNoColon/$file_name_no_colon.iv"

    $ivShapeBenchmarkFolder/ivShapeBenchmark --benchString "$shapeName $parameters" --dumpDisplay  --dump-scenegraph  $complete_file_dir
  done
done
