/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2025 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David BEILLOIN (Sep 2010)
**=======================================================================*/

#include <ivShapeBenchmarkGui_Design.h>

#include <Inventor/SbVec.h>

#include <ScaleViz/SoScaleViz.h>
#include <ScaleViz/nodes/SoScaleVizConfig.h>
#include <geometry.h>

#ifdef _WIN32
#pragma warning( push )
#pragma warning( disable:4996 )
#endif

// init static vars
ivShapeBenchmarkGuiLaunchCB ivShapeBenchmarkGui::m_launchCB=NULL;
ivShapeBenchmarkGuiAnimationChangeCB ivShapeBenchmarkGui::m_animationChange = NULL;
ivShapeBenchmarkGuiDrawStyleChangeCB ivShapeBenchmarkGui::m_drawStyleChange = NULL;
ivShapeBenchmarkGuiTransparencyTypeChangeCB ivShapeBenchmarkGui::m_transparencyTypeChange = NULL;

void ivShapeBenchmarkGui::commonInit()
{
  m_comboBox_ScaleVizMode->setCurrentIndex( 0 );

  for( int i = 0; i < SoScaleViz::getConfigurationCount(); i++ )
  {
    QString configName = QString::fromUtf16( SoScaleViz::getConfiguration(i)->name.getValue().toUtf16());
    configName.replace(' ','_');
    m_comboBox_ScaleVizMode->addItem( configName );
  }

  const QObject* _applyButton = (const QObject*)(buttonBox->button( QDialogButtonBox::Apply ));
  QObject::connect(_applyButton, SIGNAL(clicked()), this, SLOT(accept()));


  QObject::connect(m_radioButtonBufferedShape, SIGNAL(clicked()), this, SLOT(updateGui()));
  QObject::connect(m_radioButtonFaceSet, SIGNAL(clicked()), this, SLOT(updateGui()));
  QObject::connect(m_radioButtonLineSet, SIGNAL(clicked()), this, SLOT(updateGui()));
  QObject::connect(m_radioButtonPointSet, SIGNAL(clicked()), this, SLOT(updateGui()));
  QObject::connect(m_radioButtonQuadMesh, SIGNAL(clicked()), this, SLOT(updateGui()));
  QObject::connect(m_radioButtonTriangleSet, SIGNAL(clicked()), this, SLOT(updateGui()));
  QObject::connect(m_radioButtonTriangleStrip, SIGNAL(clicked()), this, SLOT(updateGui()));

  QObject::connect(m_radio_numVertices_3, SIGNAL(clicked()), this, SLOT(updateGui()));
  QObject::connect(m_radio_numVertices_4, SIGNAL(clicked()), this, SLOT(updateGui()));
  QObject::connect(m_radio_numVertices_5, SIGNAL(clicked()), this, SLOT(updateGui()));
  QObject::connect(m_checkBox_indexed, SIGNAL(clicked()), this, SLOT(updateGui()));
  QObject::connect(m_comboBox_primitive, SIGNAL(activated(QString)), this, SLOT(updateGui()));

  QObject::connect(m_spinBox_numInstance, SIGNAL(valueChanged(int)), this, SLOT(updateBenchString()));
  QObject::connect(m_spinBox_Width, SIGNAL(valueChanged(int)), this, SLOT(updateBenchString()));
  QObject::connect(m_spinBox_Height, SIGNAL(valueChanged(int)), this, SLOT(updateBenchString()));
  QObject::connect(m_checkBox_Normals, SIGNAL(stateChanged(int)), this, SLOT(updateBenchString()));
  QObject::connect(m_checkBox_Colors, SIGNAL(stateChanged(int)), this, SLOT(updateBenchString()));
  QObject::connect(m_comboBox_NormalBinding, SIGNAL(activated(QString)), this, SLOT(updateBenchString()));
  QObject::connect(m_comboBox_ColorBinding, SIGNAL(activated(QString)), this, SLOT(updateBenchString()));
  QObject::connect(m_checkBox_Texture2D, SIGNAL(stateChanged(int)), this, SLOT(updateBenchString()));
  QObject::connect(m_checkBox_Texture3D, SIGNAL(stateChanged(int)), this, SLOT(updateBenchString()));
  QObject::connect(m_checkBox_holes, SIGNAL(stateChanged(int)), this, SLOT(updateBenchString()));
  QObject::connect(m_checkBox_Attributes, SIGNAL(stateChanged(int)), this, SLOT(updateBenchString()));
  QObject::connect(m_comboBox_ScaleVizMode, SIGNAL(activated(QString)), this, SLOT(updateBenchString()));
  QObject::connect(m_checkBox_primitiveRestart, SIGNAL(clicked()), this, SLOT(updateBenchString()));

  QObject::connect(m_checkBox_transparent_shapes, SIGNAL(clicked()), this, SLOT(updateTransparentShapes()));
  QObject::connect(m_checkBox_stacked_shapes, SIGNAL(clicked()), this, SLOT(updateStackedShapes()));

  QObject::connect(m_comboBox_DrawStyle, SIGNAL(activated(QString)), this, SLOT(updateDrawStyle(QString)));
  QObject::connect(m_comboBox_transparencyType, SIGNAL(activated(QString)), this, SLOT(updatetTransparencyType(QString)));

  QObject::connect(m_sliderAnimationSpeed, SIGNAL(valueChanged(int)), this, SLOT(updateAnimationSpeed(int)));
  QObject::connect(m_checkBox_Animation, SIGNAL(stateChanged(int)), this, SLOT(updateAnimationSpeed(int)));

  m_radioButtonFaceSet->setChecked( true );

  updateGui();
}

void ivShapeBenchmarkGui::accept()
{
  if (m_Label_BenchString->text().isEmpty())
    fprintf(stderr,"no bench string defined\n");

  if ( m_launchCB!=NULL)
  {
    m_launchCB(m_Label_BenchString->text());
  }
}

void ivShapeBenchmarkGui::reject()
{
  exit(0);
}

void ivShapeBenchmarkGui::updateGui()
{
  if ( m_radioButtonFaceSet->isChecked() )
  {
    m_radio_numVertices_3->setEnabled(true);
    m_radio_numVertices_4->setEnabled(true);
    m_radio_numVertices_5->setEnabled(true);
    m_label_numVertices->setEnabled(true);
  }
  else
  {
    m_label_numVertices->setEnabled(false);
    m_radio_numVertices_3->setEnabled(false);
    m_radio_numVertices_4->setEnabled(false);
    m_radio_numVertices_5->setEnabled(false);
  }

  if (m_radioButtonPointSet->isChecked())
    m_comboBox_primitive->setCurrentIndex( (int)GeometryTool::POINTS );
  else if (m_radioButtonLineSet->isChecked())
    m_comboBox_primitive->setCurrentIndex( (int)GeometryTool::LINES );
  else if (m_radioButtonTriangleStrip->isChecked())
    m_comboBox_primitive->setCurrentIndex( (int)GeometryTool::TRIANGLE_STRIP );
  else if (m_radioButtonTriangleSet->isChecked())
    m_comboBox_primitive->setCurrentIndex( (int)GeometryTool::TRIANGLES );
  else if (m_radioButtonQuadMesh->isChecked())
    m_comboBox_primitive->setCurrentIndex( (int)GeometryTool::QUADS );
  else if (m_radioButtonFaceSet->isChecked())
  {
    if ( m_radio_numVertices_3->isChecked() )
      m_comboBox_primitive->setCurrentIndex( (int)GeometryTool::TRIANGLES );
    else if ( m_radio_numVertices_4->isChecked() )
      m_comboBox_primitive->setCurrentIndex( (int)GeometryTool::QUADS );
    else if ( m_radio_numVertices_5->isChecked() )
      m_comboBox_primitive->setCurrentIndex( (int)GeometryTool::POLYGON );
  }
  
  if (m_radioButtonBufferedShape->isChecked())
  {
    m_comboBox_primitive->setEnabled(true);
    if (m_checkBox_indexed->isChecked() && m_comboBox_primitive->currentText().contains("STRIP") )
      m_checkBox_primitiveRestart->setEnabled(true);
    else
      m_checkBox_primitiveRestart->setEnabled(false);
  }
  else
  {
    m_comboBox_primitive->setEnabled(false);
    m_checkBox_primitiveRestart->setEnabled(false);
  }
  if (m_checkBox_indexed->isChecked() == false)
    m_checkBox_primitiveRestart->setChecked(false);

  if (m_comboBox_primitive->currentText().contains("POINTS"))
    m_radio_numVertices_1->setChecked(true);
  else if (m_comboBox_primitive->currentText().contains("LINES"))
    m_radio_numVertices_4->setChecked(true);
  else if (m_comboBox_primitive->currentText().contains("LINE_STRIP"))
    m_radio_numVertices_5->setChecked(true);
  else if (m_comboBox_primitive->currentText().contains("LINE_LOOP"))
    m_radio_numVertices_5->setChecked(true);
  else if (m_comboBox_primitive->currentText().contains("TRIANGLES"))
    m_radio_numVertices_3->setChecked(true);
  else if (m_comboBox_primitive->currentText().contains("TRIANGLE_STRIP"))
    m_radio_numVertices_3->setChecked(true);
  else if (m_comboBox_primitive->currentText().contains("TRIANGLE_FAN"))
    m_radio_numVertices_5->setChecked(true);
  else if (m_comboBox_primitive->currentText().contains("QUADS"))
    m_radio_numVertices_4->setChecked(true);
  else if (m_comboBox_primitive->currentText().contains("QUAD_STRIP"))
    m_radio_numVertices_2->setChecked(true);
  else if (m_comboBox_primitive->currentText().contains("POLYGON"))
    m_radio_numVertices_5->setChecked(true);

  updateBenchString();
}


void ivShapeBenchmarkGui::updateBenchString()
{
  QString m_benchString = "";

  if (m_checkBox_indexed->isChecked())
    m_benchString += "Indexed";
  if (m_radioButtonBufferedShape->isChecked())
  {
    if (m_checkBox_primitiveRestart->isChecked())
      m_benchString += "PR";
    m_benchString += "Buffered";
    m_benchString += m_comboBox_primitive->currentText();
  }
  else if (m_radioButtonPointSet->isChecked())
    m_benchString += "PointSet";
  else if (m_radioButtonLineSet->isChecked())
    m_benchString += "LineSet";
  else if (m_radioButtonTriangleStrip->isChecked())
    m_benchString += "TriangleStripSet";
  else if (m_radioButtonTriangleSet->isChecked())
    m_benchString += "TriangleSet";
  else if (m_radioButtonQuadMesh->isChecked())
    m_benchString += "QuadMesh";
  else if (m_radioButtonFaceSet->isChecked())
    m_benchString += "FaceSet";

  if ( m_label_numVertices->isEnabled() )
  {
    m_benchString += ":";
    if ( m_radio_numVertices_3->isChecked() )
      m_benchString += "3";
    else if ( m_radio_numVertices_4->isChecked() )
      m_benchString += "4";
    else if ( m_radio_numVertices_5->isChecked() )
      m_benchString += "5";
  }
  m_benchString += " ";

  // V is required
  m_benchString += "V";

  // Attibutes
  m_benchString += (m_checkBox_Normals->isChecked()?"N":"");     // Normals
  m_benchString += (m_checkBox_Colors->isChecked()?"C":"");      // Colors
  m_benchString += (m_checkBox_Texture2D->isChecked()?"T":"");   // Texture2D
  m_benchString += (m_checkBox_Texture3D->isChecked()?"3":"");   // Texture3D
  m_benchString += (m_checkBox_Attributes->isChecked()?"A":"");  // VertexAttribs
  m_benchString += " ";

  // O for overall, V per vertex, F per face, G per face indexed, W per vertex indexed"
  // Normals Binding
  if ( m_comboBox_NormalBinding->currentText()== "OVERALL" )
    m_benchString += "O";
  else if ( m_comboBox_NormalBinding->currentText()== "PER_VERTEX" )
    m_benchString += "V";
  else if ( m_comboBox_NormalBinding->currentText()== "PER_FACE" )
    m_benchString += "F";
  else if ( m_comboBox_NormalBinding->currentText()== "PER_VERTEX_INDEXED" )
    m_benchString += "W";
  else if ( m_comboBox_NormalBinding->currentText()== "PER_FACE_INDEXED" )
    m_benchString += "G";

  // Colors Binding
  if ( m_comboBox_ColorBinding->currentText()== "OVERALL" )
    m_benchString += "O";
  else if ( m_comboBox_ColorBinding->currentText()== "PER_VERTEX" )
    m_benchString += "V";
  else if ( m_comboBox_ColorBinding->currentText()== "PER_FACE" )
    m_benchString += "F";
  else if ( m_comboBox_ColorBinding->currentText()== "PER_VERTEX_INDEXED" )
    m_benchString += "W";
  else if ( m_comboBox_ColorBinding->currentText()== "PER_FACE_INDEXED" )
    m_benchString += "G";
  m_benchString += " ";

  // Draw Style
  if ( m_comboBox_DrawStyle->currentText()== "FILLED" )
    m_benchString += "F";
  else if ( m_comboBox_DrawStyle->currentText()== "LINES" )
    m_benchString += "L";
  else if ( m_comboBox_DrawStyle->currentText()== "POINTS" )
    m_benchString += "P";
  m_benchString += " ";

  // create holes ?
  m_benchString += (m_checkBox_holes->isChecked()?"1 ":"0 ");

  // shape size and instances
  m_benchString += QString::number(m_spinBox_Width->value()) + " ";
  m_benchString += QString::number(m_spinBox_Height->value()) + " ";
  m_benchString += QString::number(m_spinBox_numInstance->value()) + " ";
  m_checkBox_transparent_shapes->setEnabled( (m_spinBox_numInstance->value() > 1) );
  m_checkBox_stacked_shapes->setEnabled( (m_spinBox_numInstance->value() > 1) );

  // force gui interactive mode
  m_benchString += "-3 ";

  // benchStart benchEnd benchFrameStepping 
  m_benchString += "0 -1 1 ";

  // scaleViz renderMode in the current configuration
  if ( !m_comboBox_ScaleVizMode->currentText().isEmpty() )
    m_benchString += m_comboBox_ScaleVizMode->currentText();

  // update benchString Label
  m_Label_BenchString->setText(m_benchString);

}

void ivShapeBenchmarkGui::updateAnimationSpeed(int newvalue)
{
  float fNewValue = 0.01f * (float)(newvalue+1);

  if (fNewValue > 1.f)
    fNewValue = 1.f;

  if (m_checkBox_Animation->isChecked() == false)
    fNewValue = 0.f;

  if (m_animationChange)
    m_animationChange(fNewValue);
}

void ivShapeBenchmarkGui::updateDrawStyle(QString item)
{
  updateBenchString();
  if (m_drawStyleChange)
    m_drawStyleChange(item);
}

void ivShapeBenchmarkGui::updatetTransparencyType(QString item)
{
  if (m_transparencyTypeChange)
    m_transparencyTypeChange(item);
}

void ivShapeBenchmarkGui::updateTransparentShapes()
{
  SoPreferences::setBool( "BENCHER_TRANSP_SHAPES", m_checkBox_transparent_shapes->isChecked() );
  m_comboBox_transparencyType->setEnabled( m_checkBox_transparent_shapes->isChecked() );
  m_label_transparencyType->setEnabled( m_checkBox_transparent_shapes->isChecked() );
}

void ivShapeBenchmarkGui::updateStackedShapes()
{
  SoPreferences::setBool( "BENCHER_STACKED_SHAPES", m_checkBox_stacked_shapes->isChecked() );
}

void ivShapeBenchmarkGui::setPickingInformation(const SbVec2s& screenPos, bool isShapePicked, const SbVec3f& coord, const SbVec3f& normal, const SbVec4f& texCoord)
{
  m_screenCoordsLabel->setText(QString("Screen coordinates: %1, %2").arg(screenPos[0]).arg(screenPos[1]));

  if (isShapePicked)
  {
    m_worldCoordsLabel->setText(QString("World coordinates: %1, %2, %3").arg(coord[0]).arg(coord[1]).arg(coord[2]));
    m_normalCoordsLabel->setText(QString("Normal: %1, %2, %3").arg(normal[0]).arg(normal[1]).arg(normal[2]));
    m_texCoordsLabel->setText(QString("Tex coords: %1, %2, %3, %4").arg(texCoord[0]).arg(texCoord[1]).arg(texCoord[2]).arg(texCoord[3]));
  }
  else
  {
    m_worldCoordsLabel->setText("World coordinates: --------");
    m_normalCoordsLabel->setText("Normal: --------");
    m_texCoordsLabel->setText("Tex coords: --------");
  }

}

#ifdef _WIN32
#pragma warning( pop )
#endif
