/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : David BEILLOIN (Sep 2010)
**=======================================================================*/


#ifndef _MAIN_DESIGN_H_
#define _MAIN_DESIGN_H_

#include <QtCore/qglobal.h>
#include <ui_ivShapeBenchmarkGui.h>

#include <Inventor/SbVec.h>

class SoQtViewer;

class ivShapeBenchmarkGui_GUI : public QDialog, public Ui::ivShapeBenchmarkGui 
{
public:
  ivShapeBenchmarkGui_GUI() {}
  ivShapeBenchmarkGui_GUI( QWidget* parent ) 
   :  QDialog( parent, Qt::WindowStaysOnTopHint )
  {
    setupUi( this );
  }

  virtual ~ivShapeBenchmarkGui_GUI() {}
};

typedef bool (*ivShapeBenchmarkGuiLaunchCB)(const QString& benchString);
typedef void (*ivShapeBenchmarkGuiAnimationChangeCB)(float newValue);
typedef void (*ivShapeBenchmarkGuiDrawStyleChangeCB)(const QString& newValue);
typedef void (*ivShapeBenchmarkGuiTransparencyTypeChangeCB)(const QString& newValue);

class ivShapeBenchmarkGui : public ivShapeBenchmarkGui_GUI
{
  Q_OBJECT

public :

  /** Constructor */
  ivShapeBenchmarkGui()
  {commonInit();};

  ivShapeBenchmarkGui(QWidget * parent)
    :ivShapeBenchmarkGui_GUI(parent)
  {commonInit();};

  void commonInit();

  /** Destructor */
  virtual ~ivShapeBenchmarkGui(){};
  
  static void setLaunchCallBack(ivShapeBenchmarkGuiLaunchCB func)
  { m_launchCB = func; }


  static void setAnimationChangeCallBack(ivShapeBenchmarkGuiAnimationChangeCB func)
  { m_animationChange = func; }

  static void setDrawStyleChangeCallBack(ivShapeBenchmarkGuiDrawStyleChangeCB func)
  { m_drawStyleChange = func; }

  static void setTransparencyTypeChangeCallBack(ivShapeBenchmarkGuiTransparencyTypeChangeCB func)
  { m_transparencyTypeChange = func; }

  void setPickingInformation(const SbVec2s& screenPos, bool isShapePicked, const SbVec3f& coord, const SbVec3f& normal, const SbVec4f& texCoord);

public Q_SLOTS:
  virtual void accept();
  virtual void reject();
  virtual void updateGui();
  virtual void updateBenchString();
  virtual void updateAnimationSpeed(int);
  virtual void updateDrawStyle(QString);
  virtual void updatetTransparencyType(QString);
  virtual void updateTransparentShapes();
  virtual void updateStackedShapes();

private :
  static ivShapeBenchmarkGuiLaunchCB m_launchCB;
  static ivShapeBenchmarkGuiAnimationChangeCB m_animationChange;
  static ivShapeBenchmarkGuiDrawStyleChangeCB m_drawStyleChange;
  static ivShapeBenchmarkGuiTransparencyTypeChangeCB m_transparencyTypeChange;
};

#endif // _MAIN_DESIGN_H_


