/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#include <QString>

#include <reporting.h>

const char* htmlHeader = 
"<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
"	<head>\n"
"		<link href=\"stylesheet.css\" media=\"all\" type=\"text/css\" rel=\"stylesheet\" />\n"
"	</head>\n"
"\n"
"	<body>\n"
"		<div id=\"container\">\n"
"			<div>	<img src=\"header.png\"></div>\n";

const char* htmlReportsMenu =
"			<div id=\"menu\">	\n"
"			      <img src=\"menuback.png\" />\n"
"				<a href=\"index_1_1.html\"><img src=\"1.png\" /></a>\n"
"				<a href=\"index_2_1.html\"><img src=\"2.png\" /></a>\n"
"				<a href=\"index_3_1.html\"><img src=\"3.png\" /></a>\n"
"				<a href=\"index_4_1.html\"><img src=\"4.png\" /></a>\n"
"				<img src=\"menuEnd.png\" />\n"
"			</div>\n"
"		\n";

const char* htmlBunchMenu =
"			<div id=\"menu\">	\n"
"			      <img src=\"menuback.png\" />\n"
"				<a href=\"index_1_1.html\"><img src=\"1.png\" /></a>\n"
"				<a href=\"index_1_2.html\"><img src=\"2.png\" /></a>\n"
"				<a href=\"index_1_3.html\"><img src=\"3.png\" /></a>\n"
"				<a href=\"index_1_4.html\"><img src=\"4.png\" /></a>\n"
"				<img src=\"menuEnd.png\" />\n"
"			</div>\n"
"		\n";

const char* htmlFooter = 
"		</div>\n"
"	</body>\n"
"</html>\n"
"\n";

//------------------------------------------------------------------------------
void
writeHtmlHeader(FILE* output, int reportIdx, int reportBunchIdx,
                 std::string reportDescription, std::string testDescription)
{
  QString header( htmlHeader );
  QString menuReports( htmlReportsMenu );
  QString menuBunch( htmlBunchMenu );

  menuReports.replace( QString( "%1.png" ).arg( reportIdx ), QString( "%1u.png" ).arg( reportIdx ) );
  menuBunch.replace( QString( "%1.png" ).arg( reportBunchIdx ), QString( "%1u.png" ).arg( reportBunchIdx ) );

  menuReports.replace( QString( "_1.html" ), QString( "_%1.html" ).arg( reportBunchIdx ) );
  menuBunch.replace( QString( "index_1_" ), QString( "index_%1_" ).arg( reportIdx ) );

  fprintf( output, header.toLatin1().data() );
  fprintf(output, menuReports.toLatin1().data());
  fprintf( output,
    "<div id=\"post\">\n"
    "<br><p font color=\"#FF0000\"><h1>%s</h1></p><br></div>\n"
    "<div id=\"interdiv\">\n"
    "</div>\n", reportDescription.c_str() );

  fprintf(output, menuBunch.toLatin1().data());

  fprintf( output,
    "<div id=\"post\">\n"
    "<br><p font color=\"#FF0000\"><h1>%s</h1></p><br></div>\n"
    "<div id=\"interdiv\">\n"
    "</div>\n", testDescription.c_str() );
}

//------------------------------------------------------------------------------
void
writeHtmlFooter(FILE* output)
{
  fprintf( output, htmlFooter );
}

//------------------------------------------------------------------------------
std::string getBindingText(GeometryTool::BindingType type)
{
  switch( type )
  {
    case GeometryTool::OVERALL: return "OVERALL";
    case GeometryTool::PER_FACE: return "PER FACE";
    case GeometryTool::PER_FACE_INDEXED: return "PER FACE INDEXED";
    case GeometryTool::PER_VERTEX: return "PER VERTEX";
    case GeometryTool::PER_VERTEX_INDEXED: return "PER VERTEX INDEXED";
    default:
      return "Unknown";
  }

  return "Unknown";
}

//------------------------------------------------------------------------------
void
writeConfigurationToHtml(GeometryTool::GeometryInfo info, FILE* output)
{
  fprintf( output, "&nbsp;&nbsp;Colors: <font color=\"#FF0000\">%s</font><br>\n", info.hasColors?"UserDefined":"Internal generator" );
  fprintf( output, "&nbsp;&nbsp;Colors binding: <font color=\"#FF0000\">%s</font><br>\n", getBindingText( info.colorsBinding ).c_str() );

  fprintf( output, "&nbsp;&nbsp;Normals: <font color=\"#FF0000\">%s</font><br>\n", info.hasNormals?"UserDefined":"Internal generator" );
  fprintf( output, "&nbsp;&nbsp;Normals binding: <font color=\"#FF0000\">%s</font><br>\n", getBindingText( info.normalsBinding ).c_str() );

  fprintf( output, "&nbsp;&nbsp;TexCoords: <font color=\"#FF0000\">%s</font><br>\n", info.hasTexCoords?"UserDefined":"Internal generator" );
  fprintf( output, "&nbsp;&nbsp;TexCoords3: <font color=\"#FF0000\">%s</font><br>\n", info.hasTexCoords3?"UserDefined":"Internal generator" );
  fprintf( output, "&nbsp;&nbsp;VertexAttribs: <font color=\"#FF0000\">%s</font><br>\n", info.hasVertexAttribs?"UserDefined":"None" );

  fprintf( output, "<br>&nbsp;&nbsp;Geometry:<br>" );
  fprintf( output, "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Id %d <br>\n", info.geomIndex );
  fprintf( output, "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;width = %d, height = %d<br>\n", info.width, info.height );
  fprintf( output, "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Vertices = %d, Primitives = %d<br>\n", info.numVertices, info.numPrimitives );
  if ( info.neighborTolerance != .0f )
    fprintf( output, "<br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; NeighborTolerance = %f<br>\n", info.neighborTolerance );
}


