/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef REPORTING_H
#define REPORTING_H

#include <stdio.h>
#include <string>

#include <geometry.h>

#define MAX_TEST_PER_BUNCH 128

#define CONV_MB( a ) ((a)/(1024*1024))
#define CONV_GB( a ) ((CONV_MB(a))/(1024*1024))


#define REPORTING_INIT() \
  static int MACROS_reportingReportIdx = 0; \
  static int MACROS_reportBunchIdx = 0; \
  static std::string MACROS_testDescription; \
  static std::string MACROS_reportDescription; \
  static std::vector< BenchTool::BenchResult > MACROS_results[MAX_TEST_PER_BUNCH]; \
  static BenchTool MACROS_bencher; \
  static size_t MACROS_previousMemoryInfo; \
  static size_t MACROS_previousMemoryDiff;
  
#define REPORTING_FINISH()

#define REPORTING_NEW_REPORT() \
  MACROS_reportBunchIdx = 0;

#define REPORTING_END_REPORT() \
  MACROS_reportingReportIdx++;


#define REPORTING_NEW_TEST_BUNCH() \
  \
  FILE* MACROS_output = fopen( QString("output\\index_%1_%2.html").arg( MACROS_reportingReportIdx + 1 ).arg( MACROS_reportBunchIdx + 1 ) \
                        .toLatin1().data(), "w" ); \
  if (!MACROS_output) \
    printf("[E] No output, cannot open the output html file\n"); \
  if (MACROS_output) \
    writeHtmlHeader( MACROS_output, MACROS_reportingReportIdx+1, MACROS_reportBunchIdx+1, MACROS_reportDescription, MACROS_testDescription ); \

#define REPORTING_END_TEST_BUNCH() \
  if (MACROS_output) \
  { \
    writeHtmlFooter( MACROS_output ); \
    fclose( MACROS_output ); \
    MACROS_output = NULL; \
  } \
  MACROS_reportBunchIdx++;

// BENCHS macros
#define REPORTING_MEMORY_BLOCK( MSG, value ) \
  MACROS_previousMemoryInfo = (value); \
  fprintf( MACROS_output, "&nbsp;&nbsp;" MSG ": <font color=\"#FF0000\">%zu</font> bytes, <font color=\"#FF0000\">%zu</font> Mb, <font color=\"#FF0000\">%zu</font> Gb<br>\n", MACROS_previousMemoryInfo, \
          CONV_MB( MACROS_previousMemoryInfo ), CONV_GB( MACROS_previousMemoryInfo ) ); 

#define REPORTING_MEMORY_BLOCK_DIFF( MSG, value ) \
  MACROS_previousMemoryDiff = (value) - MACROS_previousMemoryInfo; \
  MACROS_previousMemoryInfo = (value); \
  fprintf( MACROS_output, "&nbsp;&nbsp;" MSG ": <font color=\"#FF0000\">%zu</font> bytes (diff), <font color=\"#FF0000\">%zu</font> Mb (diff), <font color=\"#FF0000\">%zu</font> Gb (diff)<br>\n", MACROS_previousMemoryDiff, \
          CONV_MB( MACROS_previousMemoryDiff ), CONV_GB( MACROS_previousMemoryDiff ) );

#define REPORTING_BENCH( outputDir, viewer, tests ) \
  MACROS_results[MACROS_reportBunchIdx] = MACROS_bencher.bench( (outputDir), (viewer), (tests) );

#define REPORTING_FLUSH_RESULTS() \
        if (MACROS_output) \
        for (int i = 0; i < int(MACROS_results[MACROS_reportBunchIdx].size()); i++) \
        { \
         fprintf( MACROS_output, "<div id=\"post\">\n" ); \
         fprintf( MACROS_output, "<br>&nbsp;&nbsp;<b>Result <font color=\"#FF0000\">%d : ", MACROS_results[MACROS_reportBunchIdx][i].id ); \
         fprintf( MACROS_output, "%s<br>\n", MACROS_results[MACROS_reportBunchIdx][i].nodeName.c_str() );  \
         fprintf( MACROS_output, "<br>&nbsp;&nbsp;%s<br>\n", MACROS_results[MACROS_reportBunchIdx][i].benchString.c_str() ); \
         fprintf( MACROS_output, "<br></font></b>\n" ); \
         writeConfigurationToHtml( MACROS_results[MACROS_reportBunchIdx][i].shapeInfo, MACROS_output ); \
         fprintf( MACROS_output, "<br>\n" ); \
         fprintf( MACROS_output, "<br>&nbsp;&nbsp;IV file: <a href=\"%s\">IV</a><br><br>", MACROS_results[MACROS_reportBunchIdx][i].ivFilename.c_str() ); \
 \
         fprintf( MACROS_output, "&nbsp;&nbsp;First frame time: <font color=\"#FF0000\">%f</font> seconds<br><br>\n", MACROS_results[MACROS_reportBunchIdx][i].firstFrameTime ); \
         fprintf( MACROS_output, "&nbsp;&nbsp;Second frame time: <font color=\"#FF0000\">%f</font> seconds<br><br>\n", MACROS_results[MACROS_reportBunchIdx][i].secondFrameTime ); \
         fprintf( MACROS_output, "&nbsp;&nbsp;Average frame rate: <font color=\"#FF0000\">%f</font> fps<br><br>\n", MACROS_results[MACROS_reportBunchIdx][i].globalFps ); \
         fprintf( MACROS_output, "&nbsp;&nbsp;Average frame rate(excluding first two frames): <font color=\"#FF0000\">%f</font> fps<br><br>\n", MACROS_results[MACROS_reportBunchIdx][i].remainingFps ); \
         fprintf( MACROS_output, "<br>" ); \
 \
         REPORTING_MEMORY_BLOCK( "Memory before bench", MACROS_results[MACROS_reportBunchIdx][i].beforeMemoryUsage ) \
         REPORTING_MEMORY_BLOCK_DIFF( "Memory with geometry", MACROS_results[MACROS_reportBunchIdx][i].beforeRenderingMemoryUsage ) \
         REPORTING_MEMORY_BLOCK_DIFF( "Memory after first frame", MACROS_results[MACROS_reportBunchIdx][i].afterFirstFrameMemoryUsage ) \
         REPORTING_MEMORY_BLOCK_DIFF( "Memory after second frame", MACROS_results[MACROS_reportBunchIdx][i].afterSecondFrameMemoryUsage ) \
         REPORTING_MEMORY_BLOCK_DIFF( "Memory after rendering", MACROS_results[MACROS_reportBunchIdx][i].afterRenderingMemoryUsage ) \
         REPORTING_MEMORY_BLOCK_DIFF( "Memory after bench", MACROS_results[MACROS_reportBunchIdx][i].afterCleanUpMemoryUsage ) \
 \
         REPORTING_MEMORY_BLOCK( "Memory Peak", MACROS_results[MACROS_reportBunchIdx][i].peakMemoryUsage ) \
 \
 \
         if (MACROS_reportBunchIdx>=1) \
         { \
           fprintf( MACROS_output, "<p align=\"center\">" ); \
           fprintf( MACROS_output, "<a href=\"#\" onmouseover=\"Image%d.src='%s'\" onmouseout=\"Image%d.src='%s'\">",  \
            i, MACROS_results[0][i].sshotFilename.c_str(), i, MACROS_results[MACROS_reportBunchIdx][i].sshotFilename.c_str() ); \
           fprintf( MACROS_output, "<img src=\"%s\" name=\"Image%d\">", MACROS_results[MACROS_reportBunchIdx][i].sshotFilename.c_str(), i ); \
           fprintf( MACROS_output, "</a></p><br>\n" ); \
         } \
         else \
           fprintf( MACROS_output, "<p align=\"center\"><img src=\"%s\"></p><br>\n",  \
                    MACROS_results[MACROS_reportBunchIdx][i].sshotFilename.c_str() ); \
 \
         fprintf( MACROS_output, "</div>\n" ); \
         fprintf( MACROS_output, "<div id=\"interdiv\">\n</div>\n" ); \
     }


// Accessors

#define REPORTING_REPORT_SET_DESCRIPTION( description ) \
  MACROS_reportDescription = (description);

#define REPORTING_TEST_SET_DESCRIPTION( description ) \
  MACROS_testDescription = (description);

#define REPORTING_TEST_GET_INDEX() MACROS_reportBunchIdx


void writeHtmlHeader(FILE* output, int reportingReportIdx, int reportBunchIdx, 
                     std::string reportDescription, std::string testDescription);

void writeHtmlFooter(FILE* output );

void writeConfigurationToHtml(GeometryTool::GeometryInfo info, FILE* output);

#endif // REPORTING_H


