//!oiv_include <Inventor/oivShapeAttribute.h>
//!oiv_include <Inventor/oivShaderState.h>
//!oiv_include <Inventor/oivShaderVariables.h>

in vec3 vertexAttribs;

void main()
{
  vec3 normal, lightDir;
  vec4 diffuse;
  float NdotL;

  // If normal is not present, default to (0, 0, 1)
  vec3 vertexNormal = OivVertexNormal();
  if ( vertexNormal == vec3(0.0) )
    vertexNormal = vec3(0.0, 0.0, 1.0);

  normal = normalize(OivNormalMatrix() * vertexNormal);
  vec4 eposition = OivModelViewMatrix() * OivVertexPosition();	

  lightDir = normalize(vec3(OivLightSourcePosition(0)) - vec3(eposition));

  NdotL = max(dot(normal, lightDir), 0.0);	
  diffuse = OivFrontMaterialDiffuse() * OivLightSourceDiffuse(0);

  vec4 vert = OivVertexPosition() + vec4(vertexAttribs, 0.0);
  vec4 color = NdotL * diffuse * OivVertexColor() + 0.2;
  OivSetFrontColor(color);
  OivSetBackColor(color);
  OivSetTexCoord(0, OivVertexTextureCoordinate(0));
  OivSetTexCoord(1, OivVertexTextureCoordinate(1));
  gl_Position = OivModelViewProjectionMatrix() * vert;
}
