#ifndef VIEWER_H
#define VIEWER_H

#include <Inventor/Qt/viewers/SoQtExaminerViewer.h>
#include <Inventor/nodes/SoShapeHints.h>

#include <Inventor/STL/vector>

class SoShape;
class SoNode;
class SoGroup;
class SoSeparator;
class SoShapeHints;

class Viewer : public SoQtExaminerViewer
{
public:

  struct PickInformation
  {
    SbVec2s screenPosition;

    bool isShapePicked;
    SbVec3f worldCoords;
    SbVec3f normal;
    SbVec4f texCoord;
  };

  typedef void (*PickCallback)(const PickInformation&);

 
  Viewer( QWidget* parent = 0, const char* name = 0, SbBool buildInsideParent = true );

  virtual ~Viewer();

  void addNode( SoNode* node );

  void removeNode( SoNode* node );

  void removeAllNodes();

  virtual void redraw();

  void disbaleVBO( bool flag );

  void setWindindType( SoShapeHints::WindingType type );

  // 0.0 = no animation.
  // 1.0 = at each frame.
  void setAnimationRate(float rate);

  void setDrawStyle(QString value);
  void setDrawStyle( SoDrawStyle::Style style );
  void setPickCallback(PickCallback cb);
  void setTransparencyType(QString value);
  void setNeighborTolerance(float neighborTolerance);

private:

  static SbBool viewerEventCB(void*, QEvent*);

  void processPick(const SbVec2s& screenMouseCoord);

private:

  SoSeparator* m_shapesGroup;

  SoShapeHints* m_shapeHints;
  SoDrawStyle* m_drawStyle;

  SoSeparator* m_root;

  bool m_rebuildShapesList;
  
  std::vector<SoShape*> m_shapesCollection;

  int m_framesCount;
  float m_animationRate;

  PickCallback m_pickCallback;
};

#endif // VIEWER_H


