/*=======================================================================
 *** THE CONTENT OF THIS WORK IS PROPRIETARY TO FEI S.A.S, (FEI S.A.S.),            ***
 ***              AND IS DISTRIBUTED UNDER A LICENSE AGREEMENT.                     ***
 ***                                                                                ***
 ***  REPRODUCTION, DISCLOSURE,  OR USE,  IN WHOLE OR IN PART,  OTHER THAN AS       ***
 ***  SPECIFIED  IN THE LICENSE ARE  NOT TO BE  UNDERTAKEN  EXCEPT WITH PRIOR       ***
 ***  WRITTEN AUTHORIZATION OF FEI S.A.S.                                           ***
 ***                                                                                ***
 ***                        RESTRICTED RIGHTS LEGEND                                ***
 ***  USE, DUPLICATION, OR DISCLOSURE BY THE GOVERNMENT OF THE CONTENT OF THIS      ***
 ***  WORK OR RELATED DOCUMENTATION IS SUBJECT TO RESTRICTIONS AS SET FORTH IN      ***
 ***  SUBPARAGRAPH (C)(1) OF THE COMMERCIAL COMPUTER SOFTWARE RESTRICTED RIGHT      ***
 ***  CLAUSE  AT FAR 52.227-19  OR SUBPARAGRAPH  (C)(1)(II)  OF  THE RIGHTS IN      ***
 ***  TECHNICAL DATA AND COMPUTER SOFTWARE CLAUSE AT DFARS 52.227-7013.             ***
 ***                                                                                ***
 ***                   COPYRIGHT (C) 1996-2018 BY FEI S.A.S,                        ***
 ***                        BORDEAUX, FRANCE                                        ***
 ***                      ALL RIGHTS RESERVED                                       ***
**=======================================================================*/
/*=======================================================================
** Author		: David Beilloin
** Date			: 7 May 2013
**=======================================================================*/

// Open Inventor to Stl utility
// Read an Open Inventor file and save it to an STL file

#include <Inventor/SoDB.h>
#include <Inventor/SoInput.h>
#include <Inventor/nodes/SoSeparator.h>

#include <Inventor/io/STL/SoSTLFileFormat.h>
#include <Inventor/io/STL/SoSTLWriteAction.h>

SoNode* readFile(const SbString& filename)
{
  SoInput IvInput;
  if (!IvInput.openFile(filename))
  {
    fprintf(stderr,"Cannot open \"%s\" file...\n", filename.toLatin1());
    return NULL;
  }

  SoSeparator *fileContents = SoDB::readAll(&IvInput);
  if (fileContents == NULL)
  {
    fprintf(stderr,"Nothing has been read from \"%s\" file...\n", filename.toLatin1());
    return NULL;
  }
  return fileContents;
}

int main(int argc, char *argv[])
{
  // check program parameter
  if (argc < 2 || strcmp(argv[1], "--version") == 0)
  {
    printf("Inventor To STL File Format Converter\n");
    printf("Usage: %s [FileToConvert.iv]\n", argv[0]);
    printf("%s %s %s\n", SO_COMPANY_NAME, SO_LEGAL_COPYRIGHT, SO_PRODUCT_VERSION);
    return -1;
  }

  // Init modules needed
  SoDB::init();
  SoSTLFileFormat::init();


  // Read the input file
  SbString inputFileName(argv[1]);

  SoRef<SoNode> fileContents = readFile(inputFileName);
  if ( fileContents.ptr()==NULL)
    return -1;


  // Write output file
  SbString outputFileName = inputFileName;
  outputFileName += ".stl";

  fprintf(stdout, "Converting %s to %s ...", inputFileName.toLatin1(), outputFileName.toLatin1());
  try
  {
    SoSTLWriteAction toStlAction;
    toStlAction.setOutputFileName(outputFileName);
    toStlAction.setBinaryOutput(true);
    toStlAction.apply(fileContents.ptr());
  }
  catch(...)
  {
    fprintf(stderr,"Error.\n");
    return -1;
  }
  fprintf(stderr,"Done.\n");
  fileContents = NULL;

  // release used module
  SoSTLFileFormat::finish();
  SoDB::finish();

  return 0;
}
