#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xatom.h>

#include <Xm/Xm.h>
#include <Xm/RowColumn.h>
#include <Xm/BulletinB.h>
#include <Xm/CascadeB.h>
#include <Xm/CascadeBG.h>
#include <Xm/FileSB.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
#include <Xm/FileSB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>

#if !defined(__linux__) 
#  define MENUS_IN_POPUP
#endif

enum MenuEntries {
    IV_FILE = 0,
    IV_FILE_ABOUT,
    IV_FILE_OPEN,
    IV_FILE_QUIT,

    IV_EDIT,
    IV_EDIT_TRANSPARENCY,

    IV_OPTIMIZE,
    IV_OPTIMIZE_IVFIX,
    IV_OPTIMIZE_SHAPEHINTS,

    IV_MENU_NUM		// this must be the last entry
};

enum ButtonTypes {
    IV_SEPARATOR,
    IV_PUSH_BUTTON,
    IV_TOGGLE_BUTTON,
    IV_RADIO_BUTTON 
};

struct ivButton {
    const char *name;
    int   id;
    int   buttonType;  // PUSH, TOGGLE, RADIO
    const char *accelerator; // e.g. "Alt <Key> p"
    const char *accelText;   // text that appears in the menu item
};

struct ivMenuItem {
    int    id;
    Widget widget;
};

struct ivMenu {
    const char  *name;
    int    id;
    struct ivButton *subMenu;
    int    subItemCount;
};

static ivButton fileData[] = {
   {"About...", IV_FILE_ABOUT, IV_PUSH_BUTTON, 0, 0 },
   {"Open...",  IV_FILE_OPEN,  IV_PUSH_BUTTON, "Alt <Key> o", "Alt+o" },
   {"Quit",     IV_FILE_QUIT,  IV_PUSH_BUTTON, "Alt <Key> q", "Alt+q" },
};

static ivButton editData[] = {
   {"High quality transparency", IV_EDIT_TRANSPARENCY, 
					IV_TOGGLE_BUTTON, 0, 0 },
};

static ivButton optimizeData[] = {
   {"Optimize for speed (ivFix)", IV_OPTIMIZE_IVFIX, IV_TOGGLE_BUTTON, 0, 0 },
   {"Cull backfaces",  IV_OPTIMIZE_SHAPEHINTS,  IV_TOGGLE_BUTTON, 0, 0 },
};

static ivMenu pulldownData[] = {
// {name, id, subMenu, subItemCount}
   {"File",  IV_FILE, fileData, XtNumber(fileData) },
   {"Options",  IV_EDIT, editData, XtNumber(editData) },
   {"Optimize",  IV_OPTIMIZE,  optimizeData, XtNumber(optimizeData)},
};

