LDM Compression Tools
=====================

This folder contain tools to analyze and visualize effects of tiles compression
in LDM. It could be useful to check validity of custom SoDataCompressor classes.

Compression Analyzer
--------------------

Encode and decode a volume in order to analyze the compression provided by a
given compressor. The analysis data contain useful information in order to
evaluate compression's efficiency and quality.

* __Performance:__ Compressed size, compression ratio, encoding/decoding time, and
  encoding/decoding rate.
* __Statistics:__ Mean and variance of original and encoded image, and covariance
  of the two.
* __Error:__ Min and max error, Mean Absolute Error, Mean Square Error and Root
  Mean Square Error.
* __Quality:__ PSNR and mean SSIM.

```
Usage: CompressionAnalyzer volume_filename [-c compressor] [-l level]
```

* __volume_filename:__ The volume to analyze, must be a LDM file.
* __compressor:__ The name of the compression used for the analysis. Use Gzip
  by default.
* __level:__ Compression level, as defined in the compressor.

Error Display
-------------

This tool display the absolute error between two LDM volumes.

```
Usage: ErrorDisplay reference_filename test_filename [-r min max]
```

* __reference_volume:__ The volume used as reference for the error
  computation. Usually a lossless encoded volume.
* __test_filename:__ A volume to compare with the reference. Usually a lossy
  encoded volume.
* __min__ and __max:__ a range to map the error displayed. By default, map the
  error between 0.01 (1%) and 0.10 (10%).
