/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#include "metrics.h"
#include "SoVolumeAnalyzer.h"
#include "SoTileAnalyzer.h"

//*****************************************************************************
SoTileAnalyzer::SoTileAnalyzer( const VolumeInfo& info, const SbString& codec, int level, SbVec3i32 dimensions )
: m_info( info ),
  m_codec( codec ),
  m_level( level ),
  m_dimensions( dimensions ),
  m_analyzeFunction( NULL )
{
  switch ( m_info.datatype )
  {
  case SbDataType::UNSIGNED_BYTE:
    m_analyzeFunction = &SoTileAnalyzer::analyze_template<unsigned char>;
    break;
  case SbDataType::UNSIGNED_SHORT:
    m_analyzeFunction = &SoTileAnalyzer::analyze_template<unsigned short>;
    break;
  case SbDataType::UNSIGNED_INT32:
    m_analyzeFunction = &SoTileAnalyzer::analyze_template<unsigned int>;
    break;
  case SbDataType::SIGNED_BYTE:
    m_analyzeFunction = &SoTileAnalyzer::analyze_template<char>;
    break;
  case SbDataType::SIGNED_SHORT:
    m_analyzeFunction = &SoTileAnalyzer::analyze_template<short>;
    break;
  case SbDataType::SIGNED_INT32:
    m_analyzeFunction = &SoTileAnalyzer::analyze_template<int>;
    break;
  case SbDataType::FLOAT:
    m_analyzeFunction = &SoTileAnalyzer::analyze_template<float>;
    break;
  default:
    SoDebugError::post(
      "SoTileAnalyzer::SoTileAnalyser",
      "unsupported type %s", m_info.datatype.getString().toLatin1()
    );
  }
}

//*****************************************************************************
SoTileAnalyzer::~SoTileAnalyzer()
{

}

//*****************************************************************************
void SoTileAnalyzer::analyze( SoBufferObject *tileBuffer, SbTileAnalyzeData &data ) const
{
  if ( m_analyzeFunction == NULL )
  {
    SoDebugError::post( "SoTileAnalyzer::analyze", "no analyze function.");
    return;
  }

  (this->*m_analyzeFunction)( tileBuffer, data );
}
