/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#ifndef SO_VOLUME_ANALYZER_H
#define SO_VOLUME_ANALYZER_H

#include <vector>

#include <Inventor/SbTime.h>
#include <Inventor/SbString.h>

#include "VolumeInfo.h"
#include "SoTileAnalyzer.h"


struct SbVolumeAnalyzeData
{
  SbString codecName;
  std::vector<SbTileAnalyzeData> tileData;
  size_t totalUncompressedSize;
  size_t totalCompressedSize;
  SbTime totalEncodingTime;
  SbTime totalDecodingTime;
  double originalMean;
  double originalVariance;
  double decodedMean;
  double decodedVariance;
  double covariance;
  double ssim;
  double maxError;
  double minError;
  double mae;
  double mse;
  double rmse;
  double psnr;
};

/**
 * Analyse a volume tile by tile.
 */
class SoVolumeAnalyzer
{
public:
  /**
   * Constructor.
   *
   * @param codec The compressor to use for analysis.
   * @param level The compression level.
   */
  SoVolumeAnalyzer( const SbString& codec, int level = -1 );

  /**
   * Destructor.
   */
  virtual ~SoVolumeAnalyzer();

  SbString getCodec() const { return m_codec; }
  int getLevel() const { return m_level; }
  const VolumeInfo& getInfo() const { return m_info; }

  /**
   * Initialize the analyzer with an LDM file.
   *
   * @param filename A LDM file name.
   */
  bool init( const SbString& filename );

  /**
   * Analyse a LDM file compression.
   *
   * @param data     Structure that will be filled with analyse data.
   */
  void analyze( SbVolumeAnalyzeData &data ) const;

private:
  /** The compressor used for the analyse */
  SbString m_codec;

  /** The compression level associated with the codec */
  int m_level;

  VolumeInfo m_info;

  /** The LDM reader to read tiles from */
  SoRef<SoVolumeReader> m_reader;

  /** Tiles topology. */
  SoLDMTopoOctree m_topology;
};

#endif //SO_VOLUME_ANALYZER
