/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#include "metrics.h"

double psnr( double mse, const SbVec2d& range )
{
  double density = range[1] - range[0]; // density = max - min
  double d2 = density*density;
  return 10.0*std::log10( d2 / mse );
}

double ssim( double mean1, double mean2, double variance1, double variance2, double covariance, const SbVec2d& range )
{
  static const double k1 = 0.01;
  static const double k2 = 0.03;

  double dynRange = range[1] - range[0];
  double c1 = k1*dynRange;
  c1 *= c1;
  double c2 = k2*dynRange;
  c2 *= c2;

  double tmp1 = 2.0*mean1*mean2 + c1;
  tmp1 *= 2.0*covariance + c2;

  double tmp2 = mean1*mean1 + mean2*mean2 + c1;
  tmp2 *= variance1 + variance2 + c2;

  return tmp1 / tmp2;
}
