/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#pragma once

#include <cmath>
#include <cstddef>

#include <Inventor/SbVec.h>

/**
 * Compute kahan sum of an iterator.
 *
 * this sum formula is used to avoid cancellation of floating point values on great sums.
 */
template <typename InputIterator>
double kahanSum( InputIterator first, InputIterator last )
{
  double sum = 0.0;
  double compensation = 0.0;
  double y = 0.0;
  double tmpSum = 0.0;
  for ( InputIterator it = first; it != last; ++it )
  {
    y = *it - compensation;
    tmpSum = sum + y;
    compensation = ( tmpSum - sum ) - y;
    sum = tmpSum;
  }

  return sum;
}

/**
 * Compute the PSNR of a volume.
 *
 * @param  mse   The MSE of the volume.
 * @param  range Value range of the volume.
 */
double psnr( double mse, const SbVec2d& range );

/**
 * Compute the SSIM of a volume.
 *
 * @param  mean1      First volume mean.
 * @param  mean2      Second volume mean.
 * @param  variance1  Fisrt volume variance.
 * @param  variance2  Second volume variance.
 * @param  covariance Volumes covariance.
 * @param  range      Value range for the volume.
 */
double ssim( double mean1, double mean2, double variance1, double variance2, double covariance, const SbVec2d& range );
