//!oiv_include <VolumeViz/vvizGetData_frag.h>
//!oiv_include <VolumeViz/vvizTransferFunction_frag.h>

uniform VVizDataSetId data1;
uniform VVizDataSetId data2;

uniform float baseOpacity = 0.0;

uniform float minError = 0.01;
uniform float maxError = 0.10;

float mae( vec3 texCoord )
{
  float originalSample = VVizGetData(data1, texCoord);
  float decodedSample = VVizGetData(data2, texCoord);

  return abs(originalSample - decodedSample);
}

vec4 errorDisplay( in vec3 texCoord )
{
  float error = mae(texCoord);
  float gradient = smoothstep( minError, maxError, error );
  vec4 color = VVizTransferFunction( gradient, 0 );

  return vec4( color.rgb, min( baseOpacity + gradient, 1 ) );
}

// Implement VVizComputeFragmentColor for slice nodes
vec4 VVizComputeFragmentColor( VVIZ_DATATYPE vox, vec3 texCoord )
{
  return errorDisplay( texCoord );
}

// Implement VVizComputeFragmentColor for SoVolumeRender
vec4 VVizComputeFragmentColor( VVizDataSetId data, vec3 rayDir, inout VVizVoxelInfo voxelInfoFront, in VVizVoxelInfo voxelInfoBack, int maskId )
{
  return errorDisplay( voxelInfoFront.texCoord );
}
