/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#include <Inventor/SoDB.h>
#include <Inventor/SbElapsedTime.h>
#include <Inventor/devices/SoCpuDevice.h>
#include <Inventor/devices/SoGLDevice.h>
#include <Inventor/actions/SoGLRenderAction.h>

#include <recorder.h>

int64_t
currentCpuMemoryUsage()
{
  SoCpuDevice* cpu = SoCpuDevice::getDevice();
  if ( cpu )
  {
    return cpu->getProcessMemory();
  }
  
  return -1;
}

int64_t
currentGpuMemoryUsage()
{
  SoGLDevice* gpu = SoGLDevice::findFirstAvailableDevice();
  if ( gpu )
  {
    return gpu->getTotalMemory() - gpu->getAvailableMemory();
  }

  return -1;
}

BenchmarkRecorder::BenchmarkRecorder( QWidget* parent )
  : SoQtExaminerViewer( parent, "VViz Benchmark" )
  , m_record( NULL )
  , m_frame( 0 )
  , m_startingCpuMemory( 0 )
  , m_startingGpuMemory( 0 )
{
  setDecoration( FALSE );
  setTransparencyType( SoGLRenderAction::NO_SORT );
}

void
BenchmarkRecorder::record( BenchmarkRecord& record, size_t frameCount )
{
  m_record = &record;

  record.resize( frameCount );

  viewAll();
  setAutoRedraw( FALSE );

  bindNormalContext();

  m_startingCpuMemory = currentCpuMemoryUsage();
  m_startingGpuMemory = currentGpuMemoryUsage();
  m_timer.reset();

  for ( size_t i = 0; i < frameCount; i++ )
  {
    getNormalWidget()->repaint();
    QCoreApplication::processEvents();
  }

  unbindNormalContext();

  m_record = NULL;
}

void
BenchmarkRecorder::redraw()
{
  SbElapsedTime frameTimer;

  SoQtExaminerViewer::redraw();

  if ( m_record )
  {
    BenchmarkFrameRecord& frameRecord = (*m_record)[m_frame];

    frameRecord.duration = frameTimer.getElapsed();
    frameRecord.time = m_timer.getElapsed();
    frameRecord.cpuMemory = currentCpuMemoryUsage() - m_startingCpuMemory;
    frameRecord.gpuMemory = currentGpuMemoryUsage() - m_startingGpuMemory;
  }
  else
  {
    std::cout << frameTimer.getElapsed() << ";"
              << m_timer.getElapsed() << ";"
              << currentCpuMemoryUsage() - m_startingCpuMemory
              << currentGpuMemoryUsage() - m_startingGpuMemory << std::endl;
  }

  ++m_frame;
}
