/*=======================================================================
** VSG_COPYRIGHT_TAG
**=======================================================================*/
/*=======================================================================
** Author      : VSG (MMM YYYY)
**=======================================================================*/

#pragma once

#include <vector>

#include <Inventor/Qt/viewers/SoQtExaminerViewer.h>

struct BenchmarkFrameRecord
{
  double time;
  double duration;
  int64_t cpuMemory;
  int64_t gpuMemory;
};

typedef std::vector<BenchmarkFrameRecord> BenchmarkRecord;

/**
 * A viewer where the benchmark is recorded.
 */
class BenchmarkRecorder : public SoQtExaminerViewer
{
public:
  BenchmarkRecorder( QWidget* parent );
  
  /**
   * Record a benchmark on this viewer, displaying a fixed amount of frames.
   */
  void record( BenchmarkRecord& record, size_t frameCount );

protected:
  void redraw();

  SbElapsedTime m_timer;
  BenchmarkRecord* m_record;
  size_t m_frame;
  int64_t m_startingCpuMemory;
  int64_t m_startingGpuMemory;
};
